/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.admin.content;

import com.sun.star.uno.RuntimeException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.beans.QueryBean;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.entities.ThesaurusImpl;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.services.VradiStorageService;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.chorem.vradi.ui.admin.content.AdminThesaurusUI;
import org.chorem.vradi.ui.admin.popups.ThesaurusConfirmDialogUI;
import org.chorem.vradi.ui.admin.popups.ThesaurusEditUI;
import org.chorem.vradi.ui.admin.popups.ThesaurusPathChooserUI;
import org.chorem.vradi.ui.admin.popups.ThesaurusQueryChangesHandler;
import org.chorem.vradi.ui.admin.popups.ThesaurusQueryChangesUI;
import org.chorem.vradi.ui.admin.query.ThesaurusChangesTreeTableModel;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.ThesaurusCartographyUI;
import org.chorem.vradi.ui.renderers.ColorsMap;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import org.chorem.vradi.ui.tree.VradiTreeTableNode;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;

public class AdminThesaurusHandler {
    private static Log log = LogFactory.getLog(AdminThesaurusHandler.class);
    private VradiStorageService vradiStorageService = null;

    public WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    protected AdminThesaurusUI getUI(JAXXContext context) {
        return (AdminThesaurusUI)context;
    }

    public Thesaurus getThesaurus(VradiTreeTableNode parentNode) {
        Class type = parentNode.getInternalClass();
        if (!type.equals(Thesaurus.class)) {
            return null;
        }
        String id = parentNode.getId();
        return this.getThesaurus(id);
    }

    public Thesaurus getThesaurus(String id) {
        return ThesaurusDataHelper.restoreThesaurus(id);
    }

    public RootThesaurus getRootThesaurus(VradiTreeTableNode parentNode) {
        Class type = parentNode.getInternalClass();
        if (!type.equals(RootThesaurus.class)) {
            return null;
        }
        String id = parentNode.getId();
        return this.getRootThesaurus(id);
    }

    public RootThesaurus getRootThesaurus(String id) {
        return ThesaurusDataHelper.restoreRootThesaurus(id);
    }

    protected VradiTreeTableNode getSelectedNode(ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = (VradiTreeTableNode)helper.getSelectedNode();
        if (selectedNode == null) {
            selectedNode = (VradiTreeTableNode)helper.getRootNode();
        }
        return selectedNode;
    }

    public void createRootThesaurus(JAXXContext context) {
        String rootThesaurusName = JOptionPane.showInputDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askRootThesaurusName", (Object[])new Object[0]), I18n._((String)"vradi.adminThesaurus.askRootThesaurusTitle", (Object[])new Object[0]), 3);
        try {
            if (rootThesaurusName != null) {
                if (!rootThesaurusName.matches("\\w+")) {
                    JOptionPane.showMessageDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.rootThesaurusInvalidName", (Object[])new Object[0]), I18n._((String)"Error", (Object[])new Object[0]), 0);
                } else {
                    int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askCreateRootThesaurus", (Object[])new Object[]{rootThesaurusName}), I18n._((String)"vradi.admin.saveTitle", (Object[])new Object[0]), 0);
                    if (n == 0) {
                        if (VradiService.getVradiDataService().isRootThesaurusNameExists(rootThesaurusName)) {
                            int n2 = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{rootThesaurusName}), I18n._((String)"vradi.admin.warnTitle", (Object[])new Object[0]), 2);
                            if (n2 == 0) {
                                this.createRootThesaurus(context);
                            }
                            return;
                        }
                        RootThesaurus newRootThesaurus = VradiService.getVradiDataService().createRootThesaurus(rootThesaurusName);
                        ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)context.getContextValue(ThesaurusTreeTableHelper.class);
                        helper.createRootThesaurusAndSelect(newRootThesaurus.getWikittyId());
                    }
                }
            }
        }
        catch (VradiException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create root thesaurus", (Throwable)ex);
            }
            throw new RuntimeException("Can't create root thesaurus", (Object)ex);
        }
    }

    public void createThesaurus(JAXXContext context, RootThesaurus parentRootThesaurus) {
        String name;
        Thesaurus thesaurusToCreate = new ThesaurusImpl();
        String rootId = parentRootThesaurus.getWikittyId();
        thesaurusToCreate.setParent(rootId);
        thesaurusToCreate.setRootThesaurus(rootId);
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        edit.init(thesaurusToCreate, I18n._((String)"vradi.adminThesaurus.creationTitle", (Object[])new Object[0]), true);
        if (edit.isSave().booleanValue() && (name = thesaurusToCreate.getName()) != null && !name.isEmpty()) {
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(rootId);
            if (VradiService.getVradiDataService().isThesaurusNameExistsInRootThesaurus(rootThesaurus, name)) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{name}), I18n._((String)"vradi.adminThesaurus.warnTitle", (Object[])new Object[0]), 2);
                if (n == 0) {
                    this.createThesaurus(context, parentRootThesaurus);
                }
                return;
            }
            thesaurusToCreate = (Thesaurus)this.getProxy().store((BusinessEntity)thesaurusToCreate);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding thesaurus " + thesaurusToCreate.getName() + " to parent " + parentRootThesaurus.getName()));
            }
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)context.getContextValue(ThesaurusTreeTableHelper.class);
            helper.createThesaurusChildOfRootAndSelect(parentRootThesaurus.getWikittyId(), thesaurusToCreate.getWikittyId());
        }
    }

    public void createThesaurus(JAXXContext context, Thesaurus parentThesaurus) {
        String name;
        ThesaurusImpl thesaurusToCreate = new ThesaurusImpl();
        if (parentThesaurus == null) {
            return;
        }
        thesaurusToCreate.setParent(parentThesaurus.getWikittyId());
        thesaurusToCreate.setRootThesaurus(parentThesaurus.getRootThesaurus());
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        edit.init(thesaurusToCreate, I18n._((String)"vradi.adminThesaurus.creationTitle", (Object[])new Object[0]), true);
        if (edit.isSave().booleanValue() && (name = thesaurusToCreate.getName()) != null && !name.isEmpty()) {
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(thesaurusToCreate.getRootThesaurus());
            if (VradiService.getVradiDataService().isThesaurusNameExistsInRootThesaurus(rootThesaurus, name)) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{name}), I18n._((String)"vradi.admin.warnTitle", (Object[])new Object[0]), 2);
                if (n == 0) {
                    this.createThesaurus(context, parentThesaurus);
                }
                return;
            }
            this.getProxy().store((BusinessEntity)thesaurusToCreate);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding thesaurus " + thesaurusToCreate.getName() + " to parent " + parentThesaurus.getName()));
            }
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)context.getContextValue(ThesaurusTreeTableHelper.class);
            helper.createThesaurusAndSelect(parentThesaurus.getWikittyId(), thesaurusToCreate.getWikittyId());
        }
    }

    public void editRootThesaurus(JAXXContext context, RootThesaurus rootThesaurus) {
        String oldName = rootThesaurus.getName();
        String name = JOptionPane.showInputDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askRootThesaurusEditName", (Object[])new Object[]{oldName}), oldName);
        if (name != null && !name.isEmpty()) {
            if (VradiService.getVradiDataService().isRootThesaurusNameExists(rootThesaurus.getName(), rootThesaurus.getWikittyId())) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{name}), I18n._((String)"vradi.admin.warnTitle", (Object[])new Object[0]), 2);
                if (n == 0) {
                    this.editRootThesaurus(context, rootThesaurus);
                }
                return;
            }
            int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askEditRootThesaurus", (Object[])new Object[]{oldName, name}), I18n._((String)"vradi.admin.saveTitle", (Object[])new Object[0]), 2);
            if (n == 0) {
                this.modifyQueries(context, oldName, name, null, null);
                rootThesaurus.setName(name);
                log.info((Object)rootThesaurus);
                this.getProxy().store((BusinessEntity)rootThesaurus);
            }
        }
    }

    public void editThesaurus(JAXXContext context, Thesaurus thesaurus) {
        thesaurus = ThesaurusDataHelper.restoreThesaurus(thesaurus.getWikittyId());
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        String oldName = thesaurus.getName();
        edit.init(thesaurus, I18n._((String)"vradi.adminThesaurus.editTitle", (Object[])new Object[]{oldName}), false);
        if (edit.isSave().booleanValue() && oldName != null && !oldName.isEmpty()) {
            String rootId = thesaurus.getRootThesaurus();
            RootThesaurus rootThesaurus = this.getRootThesaurus(rootId);
            if (VradiService.getVradiDataService().isThesaurusNameExistsInRootThesaurus(rootThesaurus, thesaurus.getName(), thesaurus.getWikittyId())) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{oldName}), I18n._((String)"vradi.admin.warnTitle", (Object[])new Object[0]), 2);
                if (n == 0) {
                    this.editThesaurus(context, thesaurus);
                }
                return;
            }
            String newName = thesaurus.getName();
            boolean responce = true;
            if (!oldName.equals(newName)) {
                thesaurus.setName(oldName);
                responce = this.showThesaurusConfirmDialog(context, thesaurus, I18n._((String)"vradi.adminThesaurus.askEditThesaurus", (Object[])new Object[]{oldName, ThesaurusDataHelper.getNbFormsForThesaurus(thesaurus)}), I18n._((String)"vradi.admin.saveTitle", (Object[])new Object[0]));
            }
            if (responce) {
                thesaurus.setName(newName);
                this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), oldName, thesaurus.getName());
                this.getProxy().store((BusinessEntity)thesaurus);
            }
        }
    }

    public void moveThesaurus(JAXXContext context, Thesaurus thesaurus) {
        VradiTreeTableNode selectedNode;
        String newParentId;
        String thesaurusName;
        boolean responce;
        thesaurus = ThesaurusDataHelper.restoreThesaurus(thesaurus.getWikittyId());
        String rootThesaurusId = thesaurus.getRootThesaurus();
        RootThesaurus rootThesaurus = this.getRootThesaurus(rootThesaurusId);
        ThesaurusTreeTableHelper selectHelper = new ThesaurusTreeTableHelper(rootThesaurus);
        ThesaurusPathChooserUI selectUI = new ThesaurusPathChooserUI(context, selectHelper);
        VradiTreeTableNode concernedNode = selectHelper.findThesaurusNode(thesaurus);
        selectHelper.removeNode((NavNode)concernedNode);
        selectUI.setVisible(true);
        if (selectUI.isSaved().booleanValue() && (responce = this.showThesaurusConfirmDialog(context, thesaurus, I18n._((String)"vradi.adminThesaurus.askMoveThesaurus", (Object[])new Object[]{thesaurusName = thesaurus.getName()}), I18n._((String)"vradi.adminThesaurus.moveTitle", (Object[])new Object[0]))) && !(newParentId = (selectedNode = this.getSelectedNode(selectHelper)).getId()).equals(thesaurus.getParent())) {
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)context.getContextValue(ThesaurusTreeTableHelper.class);
            String rootThesaurusName = rootThesaurus.getName();
            this.modifyQueries(context, rootThesaurusName, rootThesaurusName, thesaurusName, thesaurusName);
            VradiTreeTableNode oldThesaurusNode = helper.findThesaurusNode(thesaurus);
            helper.removeNode((NavNode)oldThesaurusNode);
            helper.createThesaurusAndSelect(newParentId, thesaurus.getWikittyId());
            thesaurus.setParent(newParentId);
            this.getProxy().store((BusinessEntity)thesaurus);
        }
    }

    public void deleteRootThesaurus(JAXXContext context, RootThesaurus rootThesaurus) {
        int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askDeleteRootThesaurus", (Object[])new Object[]{rootThesaurus.getName()}), I18n._((String)"vradi.admin.deleteTitle", (Object[])new Object[0]), 2);
        if (n == 0) {
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)context.getContextValue(ThesaurusTreeTableHelper.class);
            VradiTreeTableNode nodeToDelete = helper.findRootThesaurusNode(rootThesaurus);
            helper.removeNode((NavNode)nodeToDelete);
            try {
                VradiService.getVradiDataService().deleteThesaurus(rootThesaurus.getWikittyId());
            }
            catch (VradiException ex) {
                throw new RuntimeException("Can't delete thesaurus", (Object)ex);
            }
        }
    }

    public boolean deleteThesaurus(JAXXContext context, Thesaurus thesaurus) {
        boolean response = this.showThesaurusConfirmDialog(context, thesaurus, I18n._((String)"vradi.adminThesaurus.askDeleteThesaurus", (Object[])new Object[]{thesaurus.getName(), ThesaurusDataHelper.getNbFormsForThesaurus(thesaurus)}), I18n._((String)"vradi.admin.deleteTitle", (Object[])new Object[0]));
        if (response) {
            String parentId = thesaurus.getParent();
            try {
                ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)context.getContextValue(ThesaurusTreeTableHelper.class);
                VradiTreeTableNode nodeToDelete = helper.findThesaurusNode(thesaurus);
                helper.removeNode((NavNode)nodeToDelete);
                String thesaurusId = thesaurus.getWikittyId();
                RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(thesaurus.getRootThesaurus());
                List<Thesaurus> childrenList = ThesaurusDataHelper.getChildrenRecursivly(thesaurus);
                childrenList.add(thesaurus);
                this.modifyDeleteRequest(context, rootThesaurus, thesaurus, childrenList);
                VradiService.getVradiDataService().deleteThesaurus(thesaurusId);
                VradiTreeTableNode parentNode = helper.findThesaurusNode(parentId);
                helper.selectNode((NavNode)parentNode);
            }
            catch (VradiException ex) {
                throw new RuntimeException("Can't delete thesaurus", (Object)ex);
            }
            return true;
        }
        return false;
    }

    protected void modifyDeleteRequest(JAXXContext context, RootThesaurus rootThesaurus, Thesaurus thesaurus, Collection<Thesaurus> childrenList) {
        if (ThesaurusDataHelper.isFirstChild(thesaurus)) {
            for (Thesaurus child : childrenList) {
                this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), child.getName(), "");
            }
            return;
        }
        String parentId = thesaurus.getParent();
        Thesaurus parentToPropose = ThesaurusDataHelper.restoreThesaurus(parentId);
        for (Thesaurus child : childrenList) {
            this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), child.getName(), parentToPropose == null ? child.getName() : parentToPropose.getName());
        }
    }

    public void addChildThesaurusToSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        RootThesaurus rootThesaurus = this.getRootThesaurus(selectedNode);
        if (rootThesaurus != null) {
            this.createThesaurus(context, rootThesaurus);
            return;
        }
        this.createThesaurus(context, this.getThesaurus(selectedNode));
    }

    public void editThesaurusSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        RootThesaurus rootThesaurus = this.getRootThesaurus(selectedNode);
        if (rootThesaurus != null) {
            this.editRootThesaurus(context, rootThesaurus);
            return;
        }
        this.editThesaurus(context, this.getThesaurus(selectedNode));
    }

    public void deleteThesaurusSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        RootThesaurus rootThesaurus = this.getRootThesaurus(selectedNode);
        if (rootThesaurus != null) {
            this.deleteRootThesaurus(context, rootThesaurus);
            return;
        }
        this.deleteThesaurus(context, this.getThesaurus(selectedNode));
    }

    public void moveThesaurusSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        Thesaurus thesaurus = this.getThesaurus(selectedNode);
        this.moveThesaurus(context, thesaurus);
    }

    public boolean showThesaurusConfirmDialog(JAXXContext context, Thesaurus concerned, String title, String msg) {
        ThesaurusConfirmDialogUI condirmDialogUI = new ThesaurusConfirmDialogUI(context);
        condirmDialogUI.init(concerned, title, msg);
        return condirmDialogUI.isSave();
    }

    public void showApply(JAXXContext context, Thesaurus concerned) {
        UIHelper.getHandler(context, AdminHandler.class).openRequest(context, concerned);
    }

    protected void modifyQueries(JAXXContext context, String rootThesaurusBefore, String rootThesaurusAfter, String thesaurusBefore, String thesaurusAfter) {
        Map<Group, List<QueryBean>> queryMakers = VradiService.getVradiDataService().getQueriesToModifyAfterThesaurusModification(rootThesaurusBefore, thesaurusBefore);
        if (queryMakers.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ModifyQueries] Query makers are empty for thesaurus : " + rootThesaurusBefore + ":" + thesaurusBefore));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[ModifyQueries] Query makers are not empty for thesaurus : " + rootThesaurusBefore + ":" + thesaurusBefore + " will show modification UI"));
        }
        ThesaurusQueryChangesHandler handler = new ThesaurusQueryChangesHandler();
        ThesaurusQueryChangesUI thesaurusChangesUI = handler.initUI(context, queryMakers, rootThesaurusBefore, rootThesaurusAfter, thesaurusBefore, thesaurusAfter);
        thesaurusChangesUI.setModifiedQueries(Boolean.FALSE);
        thesaurusChangesUI.setVisible(true);
        if (!thesaurusChangesUI.isModifiedQueries().booleanValue()) {
            return;
        }
        try {
            ThesaurusChangesTreeTableModel model = thesaurusChangesUI.getContextValue(ThesaurusChangesTreeTableModel.class);
            List<Group> updatedQueryMakers = model.getUpdatedQueryMakers();
            VradiService.getWikittyProxy().store(updatedQueryMakers);
            if (log.isDebugEnabled()) {
                log.debug((Object)"[ModifyQueries] Store modifications");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void changeThesaurusColor(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        Thesaurus selected = this.getThesaurus(selectedNode);
        int depth = ThesaurusDataHelper.getDepth(selected);
        Color initialColor = ColorsMap.getInstance().get(depth);
        Color colorChoosed = JColorChooser.showDialog((Component)((Object)((AdminThesaurusUI)context)), I18n._((String)"vradi.thesaurus.colorTitle", (Object[])new Object[0]), initialColor);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Store color " + colorChoosed + " for depth " + depth));
        }
        VradiHelper.storeThesaurusColor(depth, colorChoosed);
        this.reinitColors();
    }

    public void reinitColors() {
        ColorsMap.getInstance().updateColors();
    }

    public void exportThesaurusCSV(AdminThesaurusUI adminThesaurusUI) {
        block6: {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.adminThesaurus.exportThesaurusTitle", (Object[])new Object[0]));
                chooser.setApproveButtonText(I18n._((String)"vradi.adminThesaurus.exportButtonText", (Object[])new Object[0]));
                int returnVal = chooser.showOpenDialog((Component)((Object)adminThesaurusUI));
                if (returnVal == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporting thesaurus to : " + selectedFile.getAbsolutePath()));
                    }
                    VradiStorageService vradiStorageService = this.getVradiStorageService();
                    String vscContent = vradiStorageService.exportThesaurusAsCSV();
                    FileUtils.writeStringToFile((File)selectedFile, (String)vscContent);
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't export thesaurus", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)eee);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't export thesaurus", (Throwable)eee);
            }
        }
    }

    protected VradiStorageService getVradiStorageService() {
        if (this.vradiStorageService == null) {
            this.vradiStorageService = VradiService.getVradiStorageService();
        }
        return this.vradiStorageService;
    }

    public void importCSV(AdminThesaurusUI adminThesaurusUI) {
        block7: {
            int response = JOptionPane.showConfirmDialog((Component)((Object)adminThesaurusUI), I18n._((String)"Warning all your thesaurus will be deleted before new import. Do you want to continue ?", (Object[])new Object[0]), I18n._((String)"Confirm thesaurus deletion", (Object[])new Object[0]), 2);
            if (response != 0) {
                return;
            }
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.adminThesaurus.importTitle", (Object[])new Object[0]));
                chooser.setApproveButtonText(I18n._((String)"vradi.adminThesaurus.importButtonText", (Object[])new Object[0]));
                int returnVal = chooser.showOpenDialog((Component)((Object)adminThesaurusUI));
                if (returnVal == 0) {
                    VradiService.getVradiDataService().deleteAllThesaurus();
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Importing file : " + selectedFile.getAbsolutePath()));
                    }
                    VradiStorageService vradiStorageService = this.getVradiStorageService();
                    String uri = VradiService.getFileService().uploadTempFile(selectedFile);
                    vradiStorageService.importAsCSV(uri);
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import file", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)eee);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Can't import file", (Throwable)eee);
            }
        }
    }

    public static class CopyToClipboard
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected AdminThesaurusUI thesaurusUI;
        protected ThesaurusCartographyUI thesaurusCartography;

        public CopyToClipboard(AdminThesaurusUI thesaurusUI) {
            super(I18n._((String)"vradi.common.copy", (Object[])new Object[0]));
            this.thesaurusUI = thesaurusUI;
            JXTreeTable treeTable = thesaurusUI.getThesaurus();
            this.init(treeTable);
        }

        public CopyToClipboard(ThesaurusCartographyUI thesaurusCartography) {
            super(I18n._((String)"vradi.common.copy", (Object[])new Object[0]));
            this.thesaurusCartography = thesaurusCartography;
            JXTreeTable treeTable = thesaurusCartography.getThesaurus();
            this.init(treeTable);
        }

        protected void init(JXTreeTable treeTable) {
            InputMap inputMap = treeTable.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(67, 2), "ThesaurusHandler.CopyToClipboard");
            ActionMap actionMap = treeTable.getActionMap();
            actionMap.put("ThesaurusHandler.CopyToClipboard", this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThesaurusTreeTableHelper helper = this.thesaurusUI != null ? this.thesaurusUI.getHelper() : this.thesaurusCartography.getHelper();
            VradiTreeTableNode selectedNode = (VradiTreeTableNode)helper.getSelectedNode();
            if (selectedNode == null || selectedNode.isRoot()) {
                return;
            }
            String id = selectedNode.getId();
            Thesaurus selectedThesaurus = ThesaurusDataHelper.restoreThesaurus(id);
            if (selectedThesaurus == null) {
                return;
            }
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(selectedThesaurus.getRootThesaurus());
            String name = "\"" + selectedThesaurus.getName() + "\"";
            StringSelection selection = new StringSelection(rootThesaurus.getName() + ":" + name);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
        }
    }
}

