/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services;

import com.caucho.hessian.client.HessianProxyFactory;
import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConfigHelper;
import org.chorem.vradi.services.FileService;
import org.chorem.vradi.services.FileServiceImpl;
import org.chorem.vradi.services.FileServiceProxy;
import org.chorem.vradi.services.ServiceFactory;
import org.chorem.vradi.services.VradiDataService;
import org.chorem.vradi.services.VradiDataServiceImpl;
import org.chorem.vradi.services.VradiStorageService;
import org.chorem.vradi.services.VradiStorageServiceImpl;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;

public class VradiService {
    private static final Log log = LogFactory.getLog(VradiService.class);
    protected static WikittyService wikittyService;
    protected static WikittyProxy wikittyProxy;
    protected static VradiStorageService vradiStorageService;
    protected static VradiDataService vradiDataService;
    protected static FileService fileService;

    public static void initServiceProxies(ApplicationConfig configuration) {
        String serviceEndpoint = VradiConfigHelper.getRemoteEndpoint(configuration);
        if (serviceEndpoint != null && serviceEndpoint.startsWith("http://")) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Use remote mode with url : " + serviceEndpoint));
            }
            HessianProxyFactory factory = new HessianProxyFactory();
            factory.setHessian2Request(true);
            factory.setOverloadEnabled(true);
            try {
                vradiStorageService = (VradiStorageService)factory.create(VradiStorageService.class, VradiService.getServiceURL(serviceEndpoint, "vradiservice"));
                wikittyService = VradiService.initLocalWikittyService(configuration);
                fileService = new FileServiceProxy(VradiService.getServiceURL(serviceEndpoint, "file"));
            }
            catch (MalformedURLException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't init remote proxy", (Throwable)eee);
                }
            }
        } else {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Can't parse remote serveur endpoint as valid url (" + serviceEndpoint + ")"));
                log.warn((Object)"Use local embedded mode");
            }
            vradiStorageService = new VradiStorageServiceImpl();
            wikittyService = ServiceFactory.getWikittyService(configuration);
            fileService = new FileServiceImpl();
        }
        wikittyProxy = new WikittyProxy();
        wikittyProxy.setWikittyService(wikittyService);
        vradiDataService = new VradiDataServiceImpl(wikittyProxy);
    }

    protected static WikittyService initLocalWikittyService(ApplicationConfig configuration) {
        log.info((Object)("Propagation event is set to : " + VradiConfigHelper.getWikittyEventPropagate(configuration)));
        log.info((Object)("XMPP server is set to : " + VradiConfigHelper.getWikittyEventTransporterXMPPServer(configuration)));
        log.info((Object)("XMPP room is set to : " + VradiConfigHelper.getWikittyEventTransporterXMPPRoom(configuration)));
        WikittyService wikittyServiceLocal = WikittyServiceFactory.buildWikittyService((ApplicationConfig)configuration);
        return wikittyServiceLocal;
    }

    protected static String getServiceURL(String serviceEndpoint, String serviceEndUrl) {
        String fullUrl = serviceEndpoint;
        if (!fullUrl.endsWith("/")) {
            fullUrl = fullUrl + "/";
        }
        fullUrl = fullUrl + serviceEndUrl;
        return fullUrl;
    }

    public static VradiStorageService getVradiStorageService() {
        return vradiStorageService;
    }

    public static VradiDataService getVradiDataService() {
        return vradiDataService;
    }

    public static WikittyProxy getWikittyProxy() {
        return wikittyProxy;
    }

    public static WikittyService getWikittyService() {
        return wikittyService;
    }

    public static FileService getFileService() {
        return fileService;
    }
}

