/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi;

import java.io.File;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiServiceAction;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.wikitty.WikittyConfigOption;

public class VradiServiceConfiguration {
    private static final Log log = LogFactory.getLog(VradiServiceConfiguration.class);
    public static final int STEP_AFTER_INIT = 0;
    protected static ApplicationConfig config = null;
    public static final String DATA_DEFAULT_DIR = "${user.home}" + File.separator + ".vradi" + File.separator + "vradi-${application.version}";
    public static final String ATTACHEMENTS_DEFAULT_DIR_NAME = "attachments";
    public static final String SESSION_ATTACHEMENTS_DEFAULT_DIR_NAME = "sessionAttachments";
    public static final String EMBEDDED_DEFAULT_DIR_NAME = "embeddedFiles";
    public static final String QUERY_HISTORY_DEFAULT_DIR_NAME = "queryHistory";
    public static final String TEMPLATE_DEFAULT_DIR_NAME = "templates";
    public static final String PDF_DEFAULT_DIR_NAME = "pdf";
    public static final String TEMP_DEFAULT_DIR_NAME = "temp";
    public static final String EXPORT_CSV_DEFAULT_DIR_NAME = "exportCSV";
    public static final String IMPORT_CSV_DEFAULT_DIR_NAME = "importCSV";
    public static final String WEB_HARVERT_SCRIPT_DEFAULT_DIR_NAME = "WebHarvestScript";
    public static final String WEB_HARVERT_SCRIPT_PREVIEW_DEFAULT_DIR_NAME = "WebHarvestPreview";

    private VradiServiceConfiguration() {
    }

    public static ApplicationConfig getConfig(String ... args) {
        return VradiServiceConfiguration.getConfig(null, args);
    }

    public static ApplicationConfig getConfig(Properties defaults, String ... args) {
        block3: {
            if (config == null) {
                config = new ApplicationConfig(null, null, defaults, VradiServiceOption.CONFIG_FILE.getDefaultValue());
                config.loadDefaultOptions(WikittyConfigOption.class);
                config.loadDefaultOptions(VradiServiceOption.class);
                config.loadActions(VradiServiceActionDef.class);
                try {
                    config.parse(args);
                }
                catch (ArgumentsParserException eee) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Can't load vradi configuration", (Throwable)eee);
                }
            }
        }
        return config;
    }

    public static enum VradiServiceActionDef implements ApplicationConfig.ActionDef
    {
        HELP(VradiServiceAction.class.getName() + "#help", I18n._((String)"vradi.service.config.help.description", (Object[])new Object[0]), "-h", "--help"),
        REINDEX_SOLR(VradiServiceAction.class.getName() + "#reIndexSolr", I18n._((String)"vradi.service.config.reIndexSolr.description", (Object[])new Object[0]), "--reIndexSolr"),
        DELETE_OBSELETE_THESAURUS(VradiServiceAction.class.getName() + "#deleteObseleteThesaurus", I18n._((String)"vradi.service.config.deleteObseleteThesaurus.description", (Object[])new Object[0]), "--deleteObseleteThesaurus"),
        REINIT_STATUS(VradiServiceAction.class.getName() + "#reinitStatus", I18n._((String)"vradi.service.config.reinitStatus.description", (Object[])new Object[0]), "--reinitStatus"),
        FORCE_ALL_OLD_USER_ENABLE(VradiServiceAction.class.getName() + "#forceAllOldUserEnable", I18n._((String)"vradi.service.config.forceAllOldUserEnable.description", (Object[])new Object[0]), "--forceAllOldUserEnable"),
        DELETE_OBSELETE_USERS(VradiServiceAction.class.getName() + "#deleteObseleteUsers", I18n._((String)"vradi.service.config.deleteObseleteUsers.description", (Object[])new Object[0]), "--deleteObseleteUsers"),
        IMPORT_FILES(VradiServiceAction.class.getName() + "#importFiles", I18n._((String)"vradi.service.config.importFiles.description", (Object[])new Object[0]), "--importFiles"),
        EXPORT_CLIENTS(VradiServiceAction.class.getName() + "#exportClients", I18n._((String)"vradi.service.config.exportClients.description", (Object[])new Object[0]), "--exportClients"),
        EXPORT_THESAURUS(VradiServiceAction.class.getName() + "#exportThesaurus", I18n._((String)"vradi.service.config.exportThesaurus.description", (Object[])new Object[0]), "--exportThesaurus");

        protected String action;
        protected String description;
        protected String[] aliases;

        private VradiServiceActionDef(String action, String description, String ... aliases) {
            this.action = action;
            this.description = description;
            this.aliases = aliases;
        }

        public String getAction() {
            return this.action;
        }

        public String getDescription() {
            return this.action;
        }

        public String[] getAliases() {
            return this.aliases;
        }
    }

    public static enum VradiServiceOption implements ApplicationConfig.OptionDef
    {
        CONFIG_FILE("config.file", I18n._((String)"vradi.service.config.configFileName.description", (Object[])new Object[0]), "vradi-services.properties", String.class, true, true),
        APPLICATION_VERSION("application.version", I18n._((String)"vradi.service.config.application.version.description", (Object[])new Object[0]), null, String.class, false, false),
        SERVICE_VERSION("vradi.service.version", I18n._((String)"vradi.service.config.version.description", (Object[])new Object[0]), null, String.class, false, false),
        DATA_DIR("vradi.data.dir", I18n._((String)"vradi.service.config.data.dir.description", (Object[])new Object[0]), DATA_DEFAULT_DIR, String.class, false, false),
        LOCALE("vradi.service.locale", I18n._((String)"vradi.service.config.ui.locale.description", (Object[])new Object[0]), Locale.FRANCE.toString(), Locale.class, false, false),
        MAIL_ADMIN("vradi.mail.admin", I18n._((String)"vradi.service.config.mail.admin.description", (Object[])new Object[0]), null, String.class, false, false),
        OOO_DIR("oOo.exec.folder", I18n._((String)"vradi.service.config.oOo.exec.folder.description", (Object[])new Object[0]), "${user.home}/.vradi/vradi-${application.version}", String.class, false, false),
        MAIL_DEBUG("vradi.mail.debug", I18n._((String)"vradi.service.config.mail.debug.description", (Object[])new Object[0]), Boolean.FALSE.toString(), Boolean.class, false, false),
        SMTP_HOST("vradi.smtp.host", I18n._((String)"vradi.service.config.smtp.host.description", (Object[])new Object[0]), null, String.class, false, false),
        SMTP_PORT("vradi.smtp.port", I18n._((String)"vradi.service.config.smtp.port.description", (Object[])new Object[0]), null, Integer.class, false, false),
        IMAP_HOST("vradi.imap.host", I18n._((String)"vradi.service.config.imap.host.description", (Object[])new Object[0]), null, Integer.class, false, false),
        IMAP_PORT("vradi.imap.port", I18n._((String)"vradi.service.config.imap.port.description", (Object[])new Object[0]), null, Integer.class, false, false),
        MAIL_USER("vradi.mail.user", I18n._((String)"vradi.service.config.mail.user.description", (Object[])new Object[0]), null, String.class, false, false),
        MAIL_FROM("vradi.mail.from", I18n._((String)"vradi.service.config.mail.from.description", (Object[])new Object[0]), null, String.class, false, false),
        MAIL_FROM_NAME("vradi.mail.fromname", I18n._((String)"vradi.service.config.mail.fromname.description", (Object[])new Object[0]), null, String.class, false, false),
        MAIL_PASSWORD("vradi.mail.password", I18n._((String)"vradi.service.config.mail.password.description", (Object[])new Object[0]), null, String.class, false, false),
        MAIL_OFFER_SUBJECT("vradi.mail.offer.subject", I18n._((String)"vradi.service.config.mail.offer.subject.description", (Object[])new Object[0]), null, String.class, false, false),
        SESSION_DEFAULT_PARAGRAPH("vradi.session.defaultParagraph", I18n._((String)"vradi.service.config.session.defaultParagraph.description", (Object[])new Object[0]), null, String.class, false, false),
        SKIP_MIGRATION("vradi.migration.skip", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), Boolean.FALSE.toString(), Boolean.class, false, false),
        ATTACHEMENTS_DIR("vradi.attachments.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("attachments"), String.class, false, false),
        SESSION_ATTACHEMENTS_DIR("vradi.session.attachments.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("sessionAttachments"), String.class, false, false),
        EMBEDDED_DIR("vradi.embeddedFiles.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("embeddedFiles"), String.class, false, false),
        QUERY_HISTORY_DIR("vradi.queryHistory.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("queryHistory"), String.class, false, false),
        TEMPLATE_DIR("vradi.templates.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("templates"), String.class, false, false),
        PDF_DIR("vradi.pdf.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("pdf"), String.class, false, false),
        TEMP_DIR("vradi.temp.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("templates"), String.class, false, false),
        EXPORT_CSV_DIR("vradi.exportCSV.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("exportCSV"), String.class, false, false),
        IMPORT_CSV_DIR("vradi.importCSV.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("importCSV"), String.class, false, false),
        WEB_HARVERT_SCRIPT_DIR("vradi.WebHarvestScript.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("WebHarvestScript"), String.class, false, false),
        WEB_HARVERT_SCRIPT_PREVIEW_DIR("vradi.WebHarvestPreview.dir", I18n._((String)"vradi.service.config.migration.skip.description", (Object[])new Object[0]), VradiServiceOption.getDefaultDir("WebHarvestPreview"), String.class, false, false),
        AUTO_SEND_HOUR("vradi.autoSend.hour", I18n._((String)"vradi.autoSend.hour.description", (Object[])new Object[0]), null, String.class, false, false);

        public String key;
        public String description;
        public String defaultValue;
        public Class<?> type;
        public boolean isTransient;
        public boolean isFinal;

        private VradiServiceOption(String key, String description, String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isFinal = isFinal;
            this.isTransient = isTransient;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setTransient(boolean isTransient) {
            this.isTransient = isTransient;
        }

        public void setFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }

        private static String getDefaultDir(String dirName) {
            String defaultDir = "${" + VradiServiceOption.DATA_DIR.key + "}" + File.separator + dirName;
            return defaultDir;
        }
    }
}

