/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.coombs;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.votecounting.api.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.api.model.ChoiceScore;
import org.chorem.pollen.votecounting.api.model.EmptyVoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.chorem.pollen.votecounting.impl.coombs.CoombsDetailResult;
import org.chorem.pollen.votecounting.impl.coombs.CoombsRound;
import org.chorem.pollen.votecounting.impl.coombs.CoombsRoundChoice;

public class CoombsVoteCountingStrategy
extends AbstractVoteCountingStrategy<EmptyVoteCountingConfig> {
    public CoombsVoteCountingStrategy() {
        super(EmptyVoteCountingConfig.class);
    }

    @Override
    public VoteCountingResult voteCount(Set<Voter> voters) {
        Map<String, ChoiceScore> scores = this.newEmptyChoiceScoreMap(voters);
        CoombsDetailResult detailResult = new CoombsDetailResult();
        double totalWeight = voters.stream().mapToDouble(Voter::getWeight).sum() / 2.0;
        Map<Voter, List<Set<String>>> topRankChoices = this.buildVoterSortedChoices(voters);
        HashSet choiceIdsToKeep = Sets.newHashSet(scores.keySet());
        this.round(topRankChoices, choiceIdsToKeep, scores, totalWeight, detailResult, -scores.keySet().size());
        return this.orderByValues(scores.values(), detailResult);
    }

    @Override
    public Set<VoteForChoice> toVoteForChoices(VoteCountingResult voteCountingResult) {
        HashSet voteForChoices = Sets.newHashSet();
        for (ChoiceScore choiceScore : voteCountingResult.getScores()) {
            double score = choiceScore.getScoreOrder();
            VoteForChoice voteForChoice = VoteForChoice.newVote(choiceScore.getChoiceId(), score);
            voteForChoices.add(voteForChoice);
        }
        return voteForChoices;
    }

    protected void round(Map<Voter, List<Set<String>>> topRankChoices, Set<String> idsEnabled, Map<String, ChoiceScore> resultByChoice, double totalWeight, CoombsDetailResult detailResult, int roundIndex) {
        CoombsRound round = new CoombsRound();
        detailResult.getRounds().add(round);
        List<ChoiceScore> results = this.applyScores(topRankChoices, idsEnabled, resultByChoice, round);
        if (!results.isEmpty()) {
            double max;
            BigDecimal scoreValue = results.get(results.size() - 1).getScoreValue();
            double d = max = scoreValue == null ? 0.0 : scoreValue.doubleValue();
            if (max < totalWeight || max == totalWeight && idsEnabled.size() > 2) {
                Set<String> idsToExclude = this.guessChoiceIdsToRemove(idsEnabled, topRankChoices, round);
                idsEnabled.removeAll(idsToExclude);
                topRankChoices.values().stream().flatMap(Collection::stream).forEach(choiceIds -> choiceIds.removeAll(idsToExclude));
                topRankChoices.values().forEach(list -> list.removeIf(Collection::isEmpty));
                if (CollectionUtils.isNotEmpty(idsEnabled)) {
                    idsToExclude.stream().map(resultByChoice::get).forEach(score -> score.setScoreValue(BigDecimal.valueOf(roundIndex)));
                    this.round(topRankChoices, idsEnabled, resultByChoice, totalWeight, detailResult, roundIndex + 1);
                }
            }
        }
    }

    protected List<ChoiceScore> applyScores(Map<Voter, List<Set<String>>> topRankChoices, Set<String> idsEnabled, Map<String, ChoiceScore> resultByChoice, CoombsRound round) {
        for (String string : idsEnabled) {
            resultByChoice.get(string).setScoreValue(ZERO_D);
            this.addRoundChoiceFirst(round, string, 0.0);
        }
        for (Map.Entry entry : topRankChoices.entrySet()) {
            List idsByLevel = (List)entry.getValue();
            if (idsByLevel.isEmpty()) continue;
            Set winnerIds = (Set)idsByLevel.get(0);
            Voter voter = (Voter)entry.getKey();
            double voterWeight = voter.getWeight();
            for (String id : winnerIds) {
                ChoiceScore choiceScore = resultByChoice.get(id);
                choiceScore.addScoreValue(voterWeight);
                this.addRoundChoiceFirst(round, id, voterWeight);
            }
        }
        List<ChoiceScore> results = idsEnabled.stream().map(resultByChoice::get).sorted(Comparator.comparing(ChoiceScore::getScoreValue, Comparator.nullsFirst(Comparator.naturalOrder()))).collect(Collectors.toList());
        return results;
    }

    protected Set<String> guessChoiceIdsToRemove(Set<String> idsToInclude, Map<Voter, List<Set<String>>> results, CoombsRound round) {
        TreeMap badScores = Maps.newTreeMap();
        for (String string : idsToInclude) {
            badScores.put(string, ChoiceScore.newScore(string, BigDecimal.ZERO));
        }
        for (Map.Entry entry : results.entrySet()) {
            Voter voter = (Voter)entry.getKey();
            List idsChoices = (List)entry.getValue();
            if (idsChoices.isEmpty()) continue;
            Set lastIds = (Set)idsChoices.get(idsChoices.size() - 1);
            double voterWeight = voter.getWeight();
            for (String lastId : lastIds) {
                ((ChoiceScore)badScores.get(lastId)).addScoreValue(voterWeight);
                this.addRoundChoiceLast(round, lastId, voterWeight);
            }
        }
        BigDecimal maxScore = badScores.values().stream().map(ChoiceScore::getScoreValue).max(BigDecimal::compareTo).orElse(ZERO_D);
        Set<String> set = badScores.values().stream().filter(score -> maxScore.equals(score.getScoreValue())).map(ChoiceScore::getChoiceId).collect(Collectors.toSet());
        round.getChoiceIdsExclude().addAll(set);
        return set;
    }

    protected void addRoundChoiceFirst(CoombsRound round, String choiceId, double score) {
        CoombsRoundChoice roundChoice = this.getRoundChoice(round, choiceId);
        roundChoice.addFirstScore(score);
    }

    protected void addRoundChoiceLast(CoombsRound round, String choiceId, double score) {
        CoombsRoundChoice roundChoice = this.getRoundChoice(round, choiceId);
        roundChoice.addLastScore(score);
    }

    protected CoombsRoundChoice getRoundChoice(CoombsRound round, String choiceId) {
        CoombsRoundChoice result;
        Optional<CoombsRoundChoice> roundChoiceOptional = round.getRoundChoices().stream().filter(rc -> rc.getChoiceId().equals(choiceId)).findFirst();
        if (roundChoiceOptional.isPresent()) {
            result = roundChoiceOptional.get();
        } else {
            result = new CoombsRoundChoice();
            result.setChoiceId(choiceId);
            round.getRoundChoices().add(result);
        }
        return result;
    }
}

