package org.chorem.pollen.votecounting;

/*
 * #%L
 * Pollen :: VoteCounting :: Number
 * $Id: NumberVoteCounting.java 3715 2012-10-01 05:11:10Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.4/pollen-votecounting-number/src/main/java/org/chorem/pollen/votecounting/NumberVoteCounting.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.chorem.pollen.votecounting.model.ChoiceToVoteRenderType;

import java.util.Locale;

import static org.nuiton.i18n.I18n.n_;

/**
 * Coombs vote counting entry point.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.6
 */
public class NumberVoteCounting extends AbstractVoteCounting<NumberVoteCountingStrategy> {

    public static final int ID = 3;

    public NumberVoteCounting() {
        super(ID,
              NumberVoteCountingStrategy.class,
              n_("pollen.voteCountingType.number"),
              n_("pollen.voteCountingType.number.shortHelp"),
              n_("pollen.voteCountingType.number.help")
        );
    }

    @Override
    public String getDisplayVoteValue(Integer voteValue) {
        return voteValue == null ? "" : String.valueOf(voteValue);
    }

    @Override
    public boolean isChoiceInVote(Integer voteValue) {
        return voteValue != null && voteValue >= 0;
    }

    @Override
    public boolean isVoteValueNull(Integer voteValue) {
        return voteValue == null || voteValue == 0;
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    @Override
    public boolean isVoteValueValid(Integer voteValue) {
        // no validation on not null vote value
        return true;
    }

    @Override
    public boolean isTotalVoteValueValid(int totalValues) {
        // no validation on total value
        return true;
    }

    @Override
    public String getTotalVoteValueNotValidMessage(Locale locale) {
        // no validation on total values, so no message
        return null;
    }

    @Override
    public String getVoteValueNotValidMessage(Locale locale,
                                              String choiceName,
                                              String voteValue) {
        // no validation on not null vote value, so no message
        return null;
    }

}
