/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.utils;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.chorem.pollen.business.utils.MailUtil;
import org.chorem.pollen.ui.services.Configuration;
import org.h2.util.IOUtils;
import org.nuiton.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMail
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(SendMail.class);
    public static final String EXTENSION_MAIL = ".mail";
    public static final String EXTENSION_INDEX = ".index";
    protected Configuration configuration;
    protected File mailStorageDirectory;

    public SendMail(Configuration configuration) {
        this.configuration = configuration;
        String filename = configuration.getProperty("pollen.emails.directory");
        this.mailStorageDirectory = new File(filename);
        if (!this.mailStorageDirectory.exists() && this.mailStorageDirectory.mkdirs() && log.isDebugEnabled()) {
            log.debug("Email storage directory created in : " + this.mailStorageDirectory.getAbsolutePath());
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.sendAllMails();
                    this.sleep();
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) continue;
                log.error("Error during SendMail main loop", (Throwable)ex);
                continue;
            }
            break;
        }
    }

    protected synchronized void sleep() throws InterruptedException {
        this.wait();
    }

    public synchronized void wakeUp() {
        this.notifyAll();
    }

    protected void sendAllMails() throws IOException {
        List indexFiles = null;
        do {
            if (!(indexFiles = FileUtil.find((File)this.mailStorageDirectory, (String)".*\\.index", (boolean)false)).isEmpty()) {
                File indexFile = (File)indexFiles.get(0);
                String indexContent = FileUtils.readFileToString((File)indexFile, (String)"UTF-8");
                int index = Integer.parseInt(indexContent);
                File mailFile = new File(indexFile.getAbsolutePath().replaceAll(".index$", EXTENSION_MAIL));
                if (log.isDebugEnabled()) {
                    log.debug("Managing mail file : " + mailFile + " (from index " + indexContent + ")");
                }
                BufferedReader indexFileReader = new BufferedReader(new FileReader(mailFile));
                CSVReader cvsReader = new CSVReader((Reader)indexFileReader);
                int currentIndex = 0;
                String[] currentLine = cvsReader.readNext();
                while (currentLine != null) {
                    String receiver = currentLine[0];
                    String subject = currentLine[1];
                    String body = currentLine[2];
                    log.debug("Props = " + this.configuration.getConf());
                    if (currentIndex >= index) {
                        MailUtil.sendMail((String)this.configuration.getProperty("email_host"), (int)Integer.parseInt(this.configuration.getProperty("email_port")), (String)this.configuration.getProperty("email_from"), (String)receiver, (String)subject, (String)body);
                        FileUtils.writeStringToFile((File)indexFile, (String)String.valueOf(currentIndex + 1));
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            if (log.isErrorEnabled()) {
                                log.error("Can't wait between mail", (Throwable)ex);
                            }
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug("Mail to " + receiver + " already sent in a previous execution, skip.");
                    }
                    ++currentIndex;
                    currentLine = cvsReader.readNext();
                }
                mailFile.delete();
                indexFile.delete();
                continue;
            }
            if (!log.isInfoEnabled()) continue;
            log.info("No more index mail index file found, go to sleep a while :)");
        } while (!indexFiles.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareMails(String id, List<Map<String, String>> mailData) throws IOException {
        OutputStreamWriter fileWriter;
        block4: {
            fileWriter = null;
            CSVWriter cvsWriter = null;
            try {
                File emailFile = new File(this.mailStorageDirectory, id + EXTENSION_MAIL);
                fileWriter = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(emailFile)));
                cvsWriter = new CSVWriter((Writer)fileWriter);
                for (Map<String, String> singleMailData : mailData) {
                    String[] nextLine = new String[]{singleMailData.get("receiver"), singleMailData.get("subject"), singleMailData.get("body")};
                    cvsWriter.writeNext(nextLine);
                }
                File indexFile = new File(this.mailStorageDirectory, id + EXTENSION_INDEX);
                FileUtil.writeString((File)indexFile, (String)"0");
                if (cvsWriter == null) break block4;
            }
            catch (Throwable throwable) {
                if (cvsWriter != null) {
                    cvsWriter.close();
                }
                IOUtils.closeSilently(fileWriter);
                throw throwable;
            }
            cvsWriter.close();
        }
        IOUtils.closeSilently((Writer)fileWriter);
    }
}

