/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.pages.user;

import java.util.List;

import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServiceResults;
import org.chorem.pollen.ui.base.Polls;

/**
 * Classe de la page d'affichage des sondages que l'utilisateur a créés. Si
 * l'utilisateur n'est pas identifié, on lui demande d'abord de s'identifier via
 * un formulaire.
 *
 * @author rannou
 * @version $Id: UserPollsCreated.java 2701 2009-08-12 12:00:59Z nrannou $
 */
@IncludeStylesheet("context:css/pollsCreated.css")
public class UserPollsCreated extends Polls {

    /**
     * Objet de session représentant l'utilisateur identifié.
     */
    @SessionState
    private UserDTO user;
    private boolean userExists;

    /**
     * Liste de sondages de l'utilisateur
     */
    @SuppressWarnings("unused")
    @Property
    private List<PollDTO> polls;

    /**
     * Fichier XML d'un sondage exporté.
     */
    @Property
    private UploadedFile pollFile;

    /**
     * Formulaire d'import de sondage.
     */
    //@Component
    private Form importPollForm;

    /**
     * Messages.
     */
    @Inject
    private Messages messages;

    /** Injection des services */
    @Inject
    private ServicePoll servicePoll;
    @Inject
    private ServiceResults serviceResults;

    /**
     * Méthode appelée à l'importation d'un sondage.
     */
    Object onSuccessFromImportPollForm() {

        // Import du sondage
        if (pollFile != null) {
            if (!pollFile.getContentType().equals("text/xml")) {
                importPollForm.recordError(messages.format("invalidFile",
                        pollFile.getFileName()));
                return this;
            }
            serviceResults.importPoll(pollFile.getFilePath(), user);
        }

        return this;
    }

    /**
     * Méthode d'initialisation des sondages
     */
    @Override
    public void onActivate() {
        super.onActivate();
        if (userExists) {
            polls = servicePoll.findPollsByUser(user.getId());
        }
    }
}
