/*
 * Decompiled with CFR 0.152.
 */
package winstone.classLoader;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import winstone.Logger;
import winstone.WinstoneResourceBundle;

public class WebappClassLoader
extends URLClassLoader {
    private static final WinstoneResourceBundle CL_RESOURCES = new WinstoneResourceBundle("winstone.classLoader.LocalStrings");
    protected ClassLoader system = ClassLoader.getSystemClassLoader();

    public WebappClassLoader(URL[] urls) {
        super(urls);
    }

    public WebappClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public WebappClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.system.loadClass(name);
                if (c != null) {
                    Logger.log(Logger.MAX, CL_RESOURCES, "WebappClassLoader.LoadedBySystemCL", name);
                }
            }
            catch (ClassNotFoundException e) {
                c = null;
            }
        }
        if (c == null) {
            try {
                c = this.findClass(name);
                if (c != null) {
                    Logger.log(Logger.MAX, CL_RESOURCES, "WebappClassLoader.LoadedByThisCL", name);
                }
            }
            catch (ClassNotFoundException e) {
                c = null;
            }
        }
        if (c == null) {
            ClassLoader parent = this.getParent();
            if (parent != null) {
                c = parent.loadClass(name);
                if (c != null) {
                    Logger.log(Logger.MAX, CL_RESOURCES, "WebappClassLoader.LoadedByParentCL", name);
                }
            } else {
                throw new ClassNotFoundException(name);
            }
        }
        if (resolve && c != null) {
            this.resolveClass(c);
        }
        return c;
    }

    public InputStream getResourceAsStream(String name) {
        if (name != null && name.startsWith("/")) {
            name = name.substring(1);
        }
        return super.getResourceAsStream(name);
    }
}

