/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.user;

import java.util.List;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.ui.base.Polls;

@IncludeStylesheet(value={"context:css/pollsParticipated.css"})
public class UserPollsParticipated
extends Polls {
    @SessionState
    private UserDTO user;
    private boolean userExists;
    @Property
    private List<PollDTO> participatedPolls;
    @Property
    private List<PollDTO> invitedPolls;
    @Inject
    private ServicePoll servicePoll;

    public String getVoteId(PollDTO poll) {
        for (VotingListDTO list : poll.getVotingListDTOs()) {
            for (PollAccountDTO account : list.getPollAccountDTOs()) {
                if (!account.getEmail().equals(this.user.getEmail())) continue;
                return poll.getPollId() + ":" + account.getAccountId();
            }
        }
        return poll.getPollId();
    }

    public void onActivate() {
        super.onActivate();
        if (this.userExists) {
            this.participatedPolls = this.servicePoll.findParticipatedPolls(this.user.getId());
            this.invitedPolls = this.servicePoll.findInvitedPolls(this.user.getId());
        }
    }
}

