/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.ui.data.uio.DateChoiceUIO;
import org.chorem.pollen.ui.data.uio.ImageChoiceUIO;

/*
 * Exception performing whole class analysis ignored.
 */
public class PollHelper {
    public static PollDTO getPoll(PollDTO oldPoll) {
        PollDTO newPoll = new PollDTO();
        newPoll.setTitle(oldPoll.getTitle());
        newPoll.setDescription(oldPoll.getDescription());
        newPoll.setBeginChoiceDate(oldPoll.getBeginChoiceDate());
        newPoll.setBeginDate(oldPoll.getBeginDate());
        newPoll.setEndDate(oldPoll.getEndDate());
        newPoll.setAnonymous(oldPoll.isAnonymous());
        newPoll.setAnonymousVoteAllowed(oldPoll.isAnonymousVoteAllowed());
        newPoll.setPublicResults(oldPoll.isPublicResults());
        newPoll.setContinuousResults(oldPoll.isContinuousResults());
        newPoll.setChoiceAddAllowed(oldPoll.isChoiceAddAllowed());
        newPoll.setMaxChoiceNb(oldPoll.getMaxChoiceNb());
        newPoll.setChoiceType(oldPoll.getChoiceType());
        newPoll.setPollType(oldPoll.getPollType());
        newPoll.setVoteCounting(oldPoll.getVoteCounting());
        return newPoll;
    }

    public static List<VotingListDTO> getVotingLists(PollDTO oldPoll) {
        ArrayList<VotingListDTO> votingLists = new ArrayList<VotingListDTO>();
        for (VotingListDTO oldList : oldPoll.getVotingListDTOs()) {
            VotingListDTO votingList = new VotingListDTO();
            votingList.setName(oldList.getName());
            votingList.setWeight(oldList.getWeight());
            votingList.setPollAccountDTOs(PollHelper.getPollAccounts((VotingListDTO)oldList));
            votingLists.add(votingList);
        }
        return votingLists;
    }

    private static List<PollAccountDTO> getPollAccounts(VotingListDTO oldList) {
        ArrayList<PollAccountDTO> pollAccounts = new ArrayList<PollAccountDTO>();
        for (PollAccountDTO oldAccount : oldList.getPollAccountDTOs()) {
            PollAccountDTO pollAccount = new PollAccountDTO();
            pollAccount.setVotingId(oldAccount.getVotingId());
            pollAccount.setEmail(oldAccount.getEmail());
            pollAccount.setWeight(oldAccount.getWeight());
            pollAccounts.add(pollAccount);
        }
        return pollAccounts;
    }

    public static List<ChoiceDTO> getTextChoices(PollDTO oldPoll) {
        ArrayList<ChoiceDTO> choices = new ArrayList<ChoiceDTO>();
        if (oldPoll.getChoiceType() == ChoiceType.TEXT) {
            for (ChoiceDTO oldChoice : oldPoll.getChoiceDTOs()) {
                ChoiceDTO choice = new ChoiceDTO();
                choice.setName(oldChoice.getName());
                choice.setDescription(oldChoice.getDescription());
                choices.add(choice);
            }
        }
        return choices;
    }

    public static List<DateChoiceUIO> getDateChoices(PollDTO oldPoll) {
        ArrayList<DateChoiceUIO> choices = new ArrayList<DateChoiceUIO>();
        if (oldPoll.getChoiceType() == ChoiceType.DATE) {
            for (ChoiceDTO oldChoice : oldPoll.getChoiceDTOs()) {
                DateChoiceUIO choice = new DateChoiceUIO();
                choice.setName(oldChoice.getName());
                choice.setDescription(oldChoice.getDescription());
                Date date = new Date(Long.valueOf(choice.getName()));
                choice.setDate(date);
                choices.add(choice);
            }
        }
        return choices;
    }

    public static List<ImageChoiceUIO> getImageChoices(PollDTO oldPoll) {
        ArrayList<ImageChoiceUIO> choices = new ArrayList<ImageChoiceUIO>();
        if (oldPoll.getChoiceType() == ChoiceType.IMAGE) {
            // empty if block
        }
        return choices;
    }

    public static PreventRuleDTO getNotificationPreventRule(PollDTO oldPoll) {
        PreventRuleDTO preventRule = new PreventRuleDTO();
        for (PreventRuleDTO oldRule : oldPoll.getPreventRuleDTOs()) {
            if (!"vote".equals(oldRule.getScope())) continue;
            preventRule.setScope(oldRule.getScope());
            preventRule.setSensibility(oldRule.getSensibility());
            preventRule.setRepeated(oldRule.isRepeated());
            preventRule.setMethod(oldRule.getMethod());
        }
        return preventRule;
    }

    public static PreventRuleDTO getReminderPreventRule(PollDTO oldPoll) {
        PreventRuleDTO preventRule = new PreventRuleDTO();
        for (PreventRuleDTO oldRule : oldPoll.getPreventRuleDTOs()) {
            if (!"rappel".equals(oldRule.getScope())) continue;
            preventRule.setScope(oldRule.getScope());
            preventRule.setSensibility(oldRule.getSensibility());
            preventRule.setRepeated(oldRule.isRepeated());
            preventRule.setMethod(oldRule.getMethod());
        }
        return preventRule;
    }
}

