/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

public class Pager {
    @Parameter(required=true)
    private int nbTotalRows;
    @Parameter(required=true)
    private int currentPage;
    @Parameter(required=true)
    private int nbRowsPerPage;
    @Parameter(defaultPrefix="literal")
    private String noPagerText;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Inject
    private Logger log;

    void beginRender(MarkupWriter writer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("pager from : " + this.getFirstValue() + " to " + this.getLastValue());
            this.log.debug("current page : " + this.currentPage);
            this.log.debug("max nb rows : " + this.nbTotalRows);
            this.log.debug("has previous : " + this.hasPrevious());
            this.log.debug("has next : " + this.hasNext());
            this.log.debug("indexes from : " + this.getStartIndex() + " to " + this.getEndIndex());
            this.log.debug("last page : " + this.getLastPage());
        }
        writer.element("div", new Object[]{"class", "p-pager"});
        if (this.getFirstPage() == this.getLastPage()) {
            writer.write(this.noPagerText);
        } else {
            if (this.hasPrevious()) {
                int previousPage = this.currentPage - 1;
                if (previousPage != this.getFirstPage()) {
                    this.writeLink(writer, this.getFirstPage(), "<<", "p-pager-first");
                    writer.write(" ");
                }
                this.writeLink(writer, previousPage, "<", "p-pager-previous");
                writer.write(" ");
            }
            writer.element("span", new Object[]{"title", this.messages.format("rows-title", new Object[]{this.getFirstValue(), this.getLastValue(), this.nbTotalRows})});
            writer.element("strong", new Object[0]);
            writer.write(this.messages.format("page", new Object[]{this.currentPage}));
            writer.end();
            writer.end();
            if (this.hasNext()) {
                int nextPage = this.currentPage + 1;
                writer.write(" ");
                this.writeLink(writer, nextPage, ">", "p-pager-next");
                if (nextPage != this.getLastPage()) {
                    writer.write(" ");
                    this.writeLink(writer, this.getLastPage(), ">>", "p-pager-last");
                }
            }
        }
        writer.end();
    }

    void afterRender(MarkupWriter writer) {
    }

    protected void writeLink(MarkupWriter writer, int index, String text, String style) {
        Link link = this.resources.createEventLink("action", new Object[]{index});
        String title = this.messages.format("go-to", new Object[]{index});
        writer.element("a", new Object[]{"href", link, "class", style, "title", title});
        writer.write(text);
        writer.end();
    }

    public int getStartIndex() {
        return (this.currentPage - 1) * this.nbRowsPerPage;
    }

    public int getEndIndex() {
        int end = this.currentPage * this.nbRowsPerPage - 1;
        if (end >= this.nbTotalRows) {
            end = this.nbTotalRows - 1;
        }
        return end;
    }

    protected int getFirstValue() {
        return this.getStartIndex() + 1;
    }

    protected int getLastValue() {
        return this.getEndIndex() + 1;
    }

    public boolean hasPrevious() {
        return this.getStartIndex() > 0;
    }

    public boolean hasNext() {
        return this.getEndIndex() < this.nbTotalRows - 1;
    }

    public int getFirstPage() {
        return 1;
    }

    public int getLastPage() {
        return (int)Math.ceil((double)this.nbTotalRows / (double)this.nbRowsPerPage);
    }

    void onAction(int newPage) {
        this.currentPage = newPage;
    }
}

