/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.components;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.ui.components.Image;
import org.chorem.pollen.ui.components.ImageContextLink;
import org.slf4j.Logger;

public class Image
extends ImageContextLink {
    @Parameter(required=true)
    private String src;
    @Parameter
    private String alt;
    @Parameter
    private int width;
    @Parameter
    private int height;
    @Inject
    private Logger logger;
    @Inject
    private ComponentResources resources;

    public String getSrc() {
        return this.src;
    }

    public String getAlt() {
        return this.alt;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Link getThumbLink() {
        return this.resources.createEventLink("imageLink", new Object[]{this.src, this.width, this.height, true});
    }

    public Link getImageLink() {
        return this.resources.createEventLink("imageLink", new Object[]{this.src, this.width, this.height, false});
    }

    public StreamResponse onImageLink(String src, int width, int height, boolean thumb) {
        if (StringUtils.isEmpty((String)src) || src.contains("..")) {
            return null;
        }
        File file = this.getFile(src, thumb);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            this.logger.error("Fichier inexistant : " + file.getAbsolutePath(), (Throwable)e);
        }
        MimetypesFileTypeMap mimes = new MimetypesFileTypeMap();
        String type = mimes.getContentType(file);
        return new ImageStreamResponse(this, (InputStream)stream, type);
    }
}

