/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.pages.admin;

import java.util.List;

import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.ui.base.Polls;
import org.chorem.pollen.ui.components.FeedBack;

/**
 * Classe de la page d'administration des sondages. Si l'utilisateur n'est pas
 * identifié, on lui demande d'abord de s'identifier via un formulaire.
 *
 * @author rannou
 * @version $Id: PollsAdmin.java 2698 2009-08-11 10:20:19Z nrannou $
 */
@IncludeStylesheet("context:css/pollsAdmin.css")
public class PollsAdmin extends Polls {

    /** Affichage des messages pour l'utilisateur */
    @Component(id = "feedback")
    private FeedBack feedback;

    /**
     * Objet de session représentant l'utilisateur identifié.
     */
    @SessionState
    private UserDTO user;
    private boolean userExists;

    /**
     * Liste de sondages de l'utilisateur
     */
    @SuppressWarnings("unused")
    @Property
    private List<PollDTO> polls;

    /**
     * Messages.
     */
    @Inject
    private Messages messages;

    /** Injection des services */
    @Inject
    private ServicePoll servicePoll;

    /**
     * Méthode d'initialisation des sondages
     */
    @Override
    public void onActivate() {
        super.onActivate();
        polls = servicePoll.selectPolls(null);

        // Affichage des erreurs
        if (userExists && !user.isAdministrator()) {
            feedback.addError(messages.get("userNotAllowed"));
        }
    }
}
