/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.base;

import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.Retain;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.BeanModelSource;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServicePollAccount;
import org.chorem.pollen.business.services.ServiceResults;
import org.chorem.pollen.ui.data.EvenOdd;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.data.PollAction;
import org.chorem.pollen.ui.pages.admin.PollsAdmin;
import org.chorem.pollen.ui.pages.poll.ConfirmPoll;
import org.chorem.pollen.ui.pages.user.UserPollsCreated;

public class Polls {
    @SessionState
    @Property
    private UserDTO user;
    @Property
    private boolean userExists;
    private List<PollDTO> polls;
    @Property
    private PollDTO poll;
    @Property
    private EvenOdd evenOdd;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources componentResources;
    @Property
    @Retain
    private BeanModel pollsModel;
    @InjectPage
    private ConfirmPoll confirmPoll;
    @Inject
    private ServicePoll servicePoll;
    @Inject
    private ServicePollAccount servicePollAccount;
    @Inject
    private ServiceResults serviceResults;

    public String getAdminId() {
        PollAccountDTO creator = this.servicePollAccount.findPollAccountById(this.poll.getCreatorId());
        return this.poll.getPollId() + ":" + creator.getAccountId();
    }

    public Object onActionFromClose(String id) {
        return this.prepareConfirmPage(id, PollAction.CLOSE);
    }

    public Object onActionFromDeletePoll(String id) {
        return this.prepareConfirmPage(id, PollAction.DELETE);
    }

    private Object prepareConfirmPage(String pollId, PollAction pollAction) {
        String backPage = "";
        if (this instanceof UserPollsCreated) {
            backPage = "user/PollsCreated";
        } else if (this instanceof PollsAdmin) {
            backPage = "admin/PollsAdmin";
        }
        this.confirmPoll.setBackPage(backPage);
        this.confirmPoll.setAction(pollAction);
        this.confirmPoll.setPoll(this.servicePoll.findPollByPollId(pollId));
        return this.confirmPoll;
    }

    public Object onActionFromExport(String id) {
        String filename = this.serviceResults.exportPoll(id);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void onActivate() {
        this.evenOdd = new EvenOdd();
    }

    public void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
        this.pollsModel = this.beanModelSource.createDisplayModel(PollDTO.class, this.componentResources.getMessages());
        this.pollsModel.add("functions", null);
        this.pollsModel.include(new String[]{"title", "description", "beginChoiceDate", "beginDate", "endDate", "functions"});
    }
}

