
package org.chorem.pollen.ui.components;

import java.io.File;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.ui.base.ContextLink;
import org.chorem.pollen.ui.services.Configuration;

/**
 * ImageContextLink
 *
 * Created: 4 nov. 2009
 *
 * @author fdesbois
 * @version $Revision$
 *
 * Mise a jour: $Date$
 * par : $Author$
 */
public class ImageContextLink implements ContextLink {

    public static final String THUMB_PREFIX = "thumb_";

    @Inject
    private Configuration config;

    /**
     * Directory for files getting or saving from this context
     * (ie. subdirectory where images are uploaded, main directory is defined by contextPath)
     */
    @Parameter
    private String dir;

    /**
     * true for thumbnails images prefixed by {@link Configuration.IMG_DIR}
     */
    @Parameter
    private boolean thumb;

    @Override
    public String getContextPath() {
        return config.getProperty(Configuration.IMG_DIR);
    }

    @Override
    public File getFile(String filename) {
        if (thumb) {
            filename = THUMB_PREFIX + filename;
        }
        return new File(getImageDir(), filename);
    }

    /**
     * Get the directory where are uploaded the images from the context.
     * @return a File corresponding to the image directory
     */
    public File getImageDir() {
        File result = null;
        if (dir != null && !dir.isEmpty()) {
           result = new File(getContextPath(), dir);
        } else {
            result = new File(getContextPath());
        }
        return result;
    }

}
