/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.components;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.ui.components.Image;
import org.slf4j.Logger;

public class Image {
    @Parameter(required=true)
    private String _src;
    @Parameter
    private String _alt;
    @Parameter
    private int _width;
    @Parameter
    private int _height;
    @Inject
    private Logger logger;
    @Inject
    private ComponentResources _resources;

    void beginRender(MarkupWriter writer) {
        Link link = this._resources.createEventLink("imageLink", new Object[]{this._src, this._width, this._height});
        Element img = writer.element("img", new Object[]{"src", link, "alt", this._alt});
        this._resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public StreamResponse onImageLink(String src, int width, int height) {
        if (src == null || "".equals(src)) {
            return null;
        }
        File file = new File(src);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            this.logger.error("Fichier inexistant : " + file.getAbsolutePath(), (Throwable)e);
        }
        MimetypesFileTypeMap mimes = new MimetypesFileTypeMap();
        String type = mimes.getContentType(file);
        return new ImageStreamResponse(this, (InputStream)stream, type);
    }
}

