/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.components;

import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.services.ServiceAuth;
import org.chorem.pollen.business.utils.MD5;

/**
 * Formulaire d'identification. Formulaire que l'utilisateur doit remplir pour
 * se connecter quand il veut accéder à une page qui demande à être identifié.
 *
 * @author kmorin
 * @version $Id: LoginComponent.java 2737 2009-08-20 13:00:52Z nrannou $
 */
@IncludeStylesheet("context:css/loginComponent.css")
public class LoginComponent {

    /** Affichage des messages pour l'utilisateur */
    @Component(id = "loginCompFeedback")
    private FeedBack feedback;

    /**
     * Objet de session représentant l'utilisateur identifié.
     */
    @SuppressWarnings("unused")
    @SessionState
    private UserDTO user;
    @SuppressWarnings("unused")
    @Property
    private boolean userExists;

    /**
     * Champ login du formulaire d'identification
     */
    @Property
    private String loginComp;

    /**
     * Champ password du formulaire d'identification
     */
    @Property
    private String passwordComp;

    @Inject
    private Messages messages;

    /** Injection des services */
    @Inject
    private ServiceAuth serviceAuth;

    /**
     * Methode appelée lorsque l'utilisateur s'identifie
     *
     * @return la zone à mettre à jour
     */
    Object onSuccessFromLoginCompForm() {

        // Récupération de l'utilisateur identifié
        UserDTO userDTO = serviceAuth.getUser(loginComp, MD5
                .encode(passwordComp));
        if (userDTO != null) {
            user = userDTO;
        } else {
            feedback.addError(messages.get("loginFailed"));
        }
        return this;
    }
}
