/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.pages.poll;

import java.util.Date;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.ServicePoll;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.ui.data.Lien;

/**
 * Classe de la page de cloture du sondage.
 *
 * @author kmorin
 * @author rannou
 * @version $Id: ClosePoll.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class ClosePoll {

    @Persist
    private PollDTO poll;

    public PollDTO getPoll() {
        return poll;
    }

    public void setPoll(PollDTO poll) {
        this.poll = poll;
    }

    @Parameter(defaultPrefix = BindingConstants.MESSAGE, value = "title")
    @Property
    private String title;

    @SuppressWarnings("unused")
    @Property
    private Lien[] address;

    @InjectPage
    private CloseValidation closeValidation;

    /** Injection des services */
    @Inject
    private ServicePoll servicePoll;

    /**
     * Méthode appelée quand l'utilisateur valide la cloture du sondage
     *
     * @return la page de validation de cloture
     */
    Object onActionFromValidateButton() {
        for (ChoiceDTO choice : poll.getChoiceDTOs()) {
            choice.setValidate(true);
        }
        Date now = new Date();
        if (poll.getEndDate() == null || now.before(poll.getEndDate())) {
            poll.setEndDate(now);
        }
        poll.setClosed(true);
        servicePoll.updatePoll(poll);
        closeValidation.setPoll(poll);
        return closeValidation;
    }

    /**
     * Initialisation de l'affichage
     */
    void setupRender() {
        address = new Lien[] { new Lien("Pollen", "Index"),
                new Lien(title, null) };
    }
}
