/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.services.exceptions.UserNotFoundException;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class Login
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    public static final String HOME = "home";
    protected String login;
    protected String password;
    protected String redirectUrl;

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public String execute() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.login) || StringUtils.isBlank((CharSequence)this.password)) {
            this.addFlashError(this._("pollen.error.user.bad.login.or.password", new Object[0]));
        } else {
            try {
                UserAccount userAccount = this.getUserService().connect(this.login, this.password);
                this.getPollenSession().setUserAccount(userAccount);
                this.addFlashMessage(this._("pollen.information.your.are.loggued", new Object[0]));
            }
            catch (UserNotFoundException e) {
                this.addFlashError(this._("pollen.error.user.bad.login.or.password", new Object[0]));
            }
            catch (UserInvalidPasswordException e) {
                this.addFlashError(this._("pollen.error.user.bad.login.or.password", new Object[0]));
            }
        }
        String result = this.redirectUrl == null || this.redirectUrl.contains("/security") ? HOME : "success";
        return result;
    }
}

