/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.it;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.bean.PollUri;

public class PollenUrlFixtures {
    private static final Log log = LogFactory.getLog(PollenUrlFixtures.class);
    protected final String baseUrl;
    protected final PollenConfiguration configuration;

    public PollenUrlFixtures() {
        String configurationFile = System.getProperty("pollenConfigurationFile");
        Preconditions.checkNotNull((Object)configurationFile);
        this.configuration = new PollenConfiguration(configurationFile, null);
        String url = this.configuration.getApplicationUrl().toString();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.baseUrl = url;
        if (log.isInfoEnabled()) {
            log.info((Object)("Base url = " + url));
        }
    }

    protected String baseUrl() {
        return this.baseUrl;
    }

    public String home() {
        return POLLEN_URL.home.toURL(this);
    }

    public String createdList() {
        return POLLEN_URL.createdList.toURL(this);
    }

    public String invitedList() {
        return POLLEN_URL.createdList.toURL(this);
    }

    public String participatedList() {
        return POLLEN_URL.participatedList.toURL(this);
    }

    public String favoriteLists() {
        return POLLEN_URL.favoriteLists.toURL(this);
    }

    public String pollsList() {
        return POLLEN_URL.pollsList.toURL(this);
    }

    public String usersList() {
        return POLLEN_URL.usersList.toURL(this);
    }

    public String connected_required() {
        return POLLEN_URL.connected_required.toURL(this);
    }

    public String admin_required() {
        return POLLEN_URL.admin_required.toURL(this);
    }

    public String poll_required() {
        return POLLEN_URL.poll_required.toURL(this);
    }

    public String poll_access_required() {
        return POLLEN_URL.poll_access_required.toURL(this);
    }

    public String poll_creator_required() {
        return POLLEN_URL.poll_creator_required.toURL(this);
    }

    public String voteforPoll(PollUri pollUri) {
        return POLLEN_URL.voteforPoll.toURL(this, pollUri);
    }

    public String createPoll() {
        return POLLEN_URL.createPoll.toURL(this);
    }

    public String editPoll(PollUri pollUri) {
        return POLLEN_URL.editPoll.toURL(this, pollUri);
    }

    public String summaryPoll(PollUri pollUri) {
        return POLLEN_URL.summaryPoll.toURL(this, pollUri);
    }

    public String summaryPoll() {
        return POLLEN_URL.summaryPoll.toURL(this);
    }

    public String moderatePoll(PollUri pollUri) {
        return POLLEN_URL.moderatePoll.toURL(this, pollUri);
    }

    public String moderatePoll() {
        return POLLEN_URL.moderatePoll.toURL(this);
    }

    public String logout() {
        return POLLEN_URL.logout.toURL(this);
    }

    private static enum POLLEN_URL {
        poll_creator_required("security/illegal_access"),
        poll_access_required("security/illegal_access"),
        poll_required("security/illegal_access"),
        admin_required("security/admin_required"),
        connected_required("security/connected_required"),
        home("home"),
        createdList("user/createdList"),
        invitedList("user/invitedList"),
        participatedList("user/participatedList"),
        favoriteLists("user/favoriteLists"),
        logout("user/logout"),
        pollsList("admin/pollsList"),
        usersList("admin/usersList"),
        createPoll("poll/create"),
        editPoll("poll/edit", "!input"),
        voteforPoll("poll/votefor"),
        moderatePoll("poll/moderate"),
        summaryPoll("poll/summary");

        private final String path;
        private final String suffix;

        private POLLEN_URL(String path, String suffix) {
            this.path = path;
            this.suffix = suffix;
        }

        private POLLEN_URL(String path) {
            this(path, null);
        }

        public String getPath() {
            return this.path;
        }

        public String toURL(PollenUrlFixtures fixtures) {
            String result = this.toURL(fixtures, null);
            return result;
        }

        public String toURL(PollenUrlFixtures fixtures, PollUri pollUri) {
            String result = fixtures.baseUrl() + this.getPath();
            if (pollUri != null) {
                result = result + "/" + pollUri.toString();
                if (this.suffix != null) {
                    result = result + this.suffix;
                }
            }
            return result;
        }
    }
}

