/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: GetCreatedPolls.java 3702 2012-09-23 13:48:42Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.2/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetCreatedPolls.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.services.impl.SecurityService;
import org.nuiton.util.beans.Binder;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Obtain created polls to put in grid for the connected user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetCreatedPolls extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] data;

    @Override
    public Map<String, Object>[] getData() {
        return data;
    }

    @Override
    public String execute() throws Exception {

        PollService pollService = getPollService();

        List<Poll> pollList = pollService.getCreatedPolls(
                pager,
                getPollenUserAccount());

        data = new Map[pollList.size()];
        Binder<Poll, Poll> binder =
                PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;

        for (Poll poll : pollList) {

            Map<String, Object> map = pollService.pollToMap(poll, binder);

            map.put("voteId", poll.getPollId());
            map.put("resultId", poll.getPollId());
            map.put("adminId", poll.getAdminId());
            map.put("functions", getPollFunctions(poll));
            data[index++] = map;
        }
        return SUCCESS;
    }

    protected Set<String> getPollFunctions(Poll poll) {
        Set<String> result = Sets.newHashSet();

        PollenUserSecurityContext securityContext =
                PollenUserSecurityContext.newContext(
                        getPollenUserAccount(), poll.getPollId(), null, poll);
        SecurityService securityService = getSecurityService();

        securityContext.loadUserRoles(securityService);

        boolean canAccessResult =
                securityService.isCanAccessResult(securityContext);

        if (canAccessResult) {

            // only if results are public
            result.add("result");
        } else {
            result.add("noresult");
        }

        boolean canVote = securityService.isCanVote(securityContext);

        if (canVote) {
            result.add("vote");
        } else {

            // try to see if can access vote

            boolean canAccessVote =
                    securityService.isCanAccessVote(securityContext);

            if (canAccessVote) {
                result.add("accessVote");
            } else {

                // noaccess at all to vote page
                result.add("novote");
            }
        }

        result.add("summary");
        return result;
    }

}
