/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: PollenUIUtils.java 3611 2012-08-13 14:11:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/PollenUIUtils.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui;

import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.business.persistence.Poll;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import java.util.Locale;

import static org.nuiton.i18n.I18n.l_;

/**
 * Useful ui methods.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenUIUtils {

    /** Keep the servlet context */
    private static ServletContext servletContext;

    private static final String POLLEN_USER_SECURITY_CONTEXT = "pollenUserSecurityContext";

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static void setServletContext(ServletContext servletContext) {
        PollenUIUtils.servletContext = servletContext;
    }

    public static void setUserSecuritycontext(ServletRequest request,
                                              PollenUserSecurityContext userRoles) {
        request.setAttribute(POLLEN_USER_SECURITY_CONTEXT, userRoles);
    }

    public static PollenUserSecurityContext getUserSecurityContext(ServletRequest request) {
        PollenUserSecurityContext result = (PollenUserSecurityContext)
                request.getAttribute(POLLEN_USER_SECURITY_CONTEXT);
        return result;
    }

    public static String getVoteSizeMessage(Poll poll, Locale locale) {

        int i = poll.sizeVote();
        String result;
        if (i == 0) {
            result = l_(locale, "pollen.common.voteNoVote");
        } else if (i == 1) {
            result = l_(locale, "pollen.common.voteOneVote");
        } else {
            result = l_(locale, "pollen.common.voteNbVotes", i);
        }
        return result;
    }

    protected PollenUIUtils() {
        // helper can not be instanciated
    }
}
