/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: ConfirmDeleteComment.java 3257 2012-04-13 11:28:02Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/ConfirmDeleteComment.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.services.exceptions.PollCommentNotFound;
import org.chorem.pollen.services.impl.PollCommentService;

/**
 * To confirm a comment delete.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ConfirmDeleteComment extends AbstractPollUriIdAction {

    private static final long serialVersionUID = 1L;

    /** Id of the comment. */
    protected String commentId;

    /** Comment to delete. */
    protected Comment comment;

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    public Comment getComment() {
        return comment;
    }

    @Override
    public String execute() throws Exception {

        String pollId = getPollId();
        Preconditions.checkNotNull(pollId);
        Preconditions.checkNotNull(commentId);

        PollCommentService service = newService(PollCommentService.class);

        comment = service.getEntityById(Comment.class, commentId);

        if (comment == null) {
            throw new PollCommentNotFound();
        }

        return SUCCESS;
    }
}