/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.entity.FavoriteList;
import org.chorem.pollen.persistence.entity.FavoriteListMember;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.service.FavoriteListImport;
import org.chorem.pollen.services.service.FavoriteListImportException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FavoriteListImportFromFile
extends PollenServiceSupport
implements FavoriteListImport {
    private static final Logger log = LoggerFactory.getLogger(FavoriteListImportFromFile.class);
    protected File file;

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void doImport(FavoriteList favoriteList, List<FavoriteListMember> existingFavoriteListMembers) throws FavoriteListImportException {
        List lines;
        this.checkIsConnected();
        this.checkNotNull(favoriteList);
        this.checkNotNull(existingFavoriteListMembers);
        this.checkNotNull(this.file);
        this.checkState(this.file.exists());
        HashMap<String, String> usedNamesByEmails = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(existingFavoriteListMembers)) {
            for (FavoriteListMember member : existingFavoriteListMembers) {
                usedNamesByEmails.put(member.getEmail(), member.getName());
            }
        }
        try {
            lines = Files.readLines((File)this.file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new PollenTechnicalException(e);
        }
        LinkedList<String> errors = new LinkedList<String>();
        LinkedList<ImportLine> importLines = new LinkedList<ImportLine>();
        int lineNumber = 1;
        for (String line : lines) {
            String[] columns;
            if (StringUtils.isNotBlank((CharSequence)line) && !line.startsWith("#") && (columns = line.split(";")).length > 0) {
                String email = this.getCleanMail(columns[0]);
                String memberName = columns.length >= 2 ? columns[1] : email;
                String weight = columns.length >= 3 ? columns[2] : null;
                ImportLine importLine = new ImportLine(email, memberName, weight);
                if (!memberName.equals(usedNamesByEmails.get(email))) {
                    importLines.add(importLine);
                }
                this.checkLine(errors, importLine, lineNumber, usedNamesByEmails);
            }
            ++lineNumber;
        }
        if (CollectionUtils.isNotEmpty(errors)) {
            throw new FavoriteListImportException(errors);
        }
        for (ImportLine importLine : importLines) {
            FavoriteListMember member = (FavoriteListMember)this.getFavoriteListMemberDao().create();
            String memberName = importLine.memberName();
            String email = importLine.email();
            String weightString = importLine.weightString();
            double weight = StringUtils.isNotBlank((CharSequence)weightString) ? Double.parseDouble(weightString) : 1.0;
            member.setName(memberName);
            member.setEmail(email);
            member.setWeight(weight);
            member.setFavoriteList(favoriteList);
            if (!log.isDebugEnabled()) continue;
            log.debug(String.format("imported member %s / %s", memberName, email));
        }
        this.commit();
    }

    protected void checkLine(List<String> errors, ImportLine importLine, int lineNumber, Map<String, String> usedNamesByEmails) {
        Locale locale = this.serviceContext.getLocale();
        String email = importLine.email();
        if (!StringUtil.isEmail((String)email)) {
            errors.add(I18n.l((Locale)locale, (String)"pollen.error.favoriteList.import.csv.invalid.email", (Object[])new Object[]{lineNumber, email}));
        }
        String memberName = importLine.memberName();
        if (usedNamesByEmails.containsKey(email) && !usedNamesByEmails.containsValue(memberName)) {
            errors.add(I18n.l((Locale)locale, (String)"pollen.error.favoriteList.import.csv.already.used.email", (Object[])new Object[]{lineNumber, email}));
        } else if (!usedNamesByEmails.containsKey(email) && usedNamesByEmails.containsValue(memberName)) {
            errors.add(I18n.l((Locale)locale, (String)"pollen.error.favoriteList.import.csv.already.used.name", (Object[])new Object[]{lineNumber, memberName}));
        } else {
            usedNamesByEmails.put(email, memberName);
        }
        String weightString = importLine.weightString();
        if (StringUtils.isNotBlank((CharSequence)weightString)) {
            try {
                double weight = Double.parseDouble(weightString);
                if (weight <= 0.0) {
                    errors.add(I18n.l((Locale)locale, (String)"pollen.error.favoriteList.import.csv.weight.negativeOrNull", (Object[])new Object[]{lineNumber, weightString}));
                }
            }
            catch (NumberFormatException e) {
                errors.add(I18n.l((Locale)locale, (String)"pollen.error.favoriteList.import.csv.weight.notNumber", (Object[])new Object[]{lineNumber, weightString}));
            }
        }
    }

    public record ImportLine(String email, String memberName, String weightString) {
    }
}

