/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.ChoiceType;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollType;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenToken;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.services.bean.ChoiceBean;
import org.chorem.pollen.services.bean.PollBean;
import org.chorem.pollen.services.bean.PollStatus;
import org.chorem.pollen.services.bean.PollSummaryBean;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.bean.PollenEntityRef;
import org.chorem.pollen.services.bean.QuestionBean;
import org.chorem.pollen.services.bean.ReportResumeBean;
import org.chorem.pollen.services.bean.VoterListBean;
import org.chorem.pollen.services.bean.VoterListMemberBean;
import org.chorem.pollen.services.bean.export.ExportBean;
import org.chorem.pollen.services.config.PollenServicesConfig;
import org.chorem.pollen.services.service.ErrorMap;
import org.chorem.pollen.services.service.InvalidFormException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.Polls;
import org.chorem.pollen.services.service.QuestionService;
import org.chorem.pollen.services.service.security.PollenPermissions;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.nuiton.i18n.I18n;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class PollService
extends PollenServiceSupport {
    public static final String EMAIL_SUFFIX_SEPARATOR = ";";

    public PollBean toPollBean(Poll entity) {
        Date now;
        PollBean bean = new PollBean();
        bean.setEntityId(entity.getTopiaId());
        PollenPrincipal creator = entity.getCreator();
        if (creator == null || creator.getPermission() == null) {
            bean.setPermission(null);
        } else {
            bean.setPermission(creator.getPermission().getToken());
        }
        if (creator != null) {
            bean.setCreatorName(creator.getName());
            bean.setCreatorEmail(creator.getEmail());
        }
        bean.setTitle(entity.getTitle());
        bean.setDescription(entity.getDescription());
        bean.setCreateDate(entity.getTopiaCreateDate());
        bean.setBeginDate(entity.getBeginDate());
        bean.setEndDate(entity.getEndDate());
        bean.setAnonymousVoteAllowed(entity.isAnonymousVoteAllowed());
        bean.setContinuousResults(entity.isContinuousResults());
        bean.setPollType(entity.getPollType());
        bean.setVoteVisibility(entity.getVoteVisibility());
        bean.setCommentVisibility(entity.getCommentVisibility());
        bean.setResultVisibility(entity.getResultVisibility());
        bean.setNotifyMeHoursBeforePollEnds(entity.getNotifyMeHoursBeforePollEnds());
        bean.setVoteNotification(entity.isVoteNotification());
        bean.setCommentNotification(entity.isCommentNotification());
        bean.setNewChoiceNotification(entity.isNewChoiceNotification());
        bean.setNotificationLocale(entity.getNotificationLocale());
        if (entity.getPicture() != null) {
            bean.setPicture(this.getPollenResourceService().getReduceIdByTopiaId(entity.getPicture().getTopiaId()));
        }
        bean.setBuiltinPicture(entity.getBuiltinPicture());
        bean.setResultPresentation(entity.getResultPresentation());
        String emailAddressSuffixes = entity.getEmailAddressSuffixes();
        if (StringUtils.isNotBlank((CharSequence)emailAddressSuffixes)) {
            bean.setEmailAddressSuffixes(Lists.newArrayList((Object[])emailAddressSuffixes.split(EMAIL_SUFFIX_SEPARATOR)));
        }
        if (Polls.isFinished(entity, now = this.getNow())) {
            bean.setStatus(PollStatus.CLOSED);
            bean.setClosed(true);
        } else {
            bean.setClosed(false);
            bean.setStatus(PollStatus.CREATED);
            Date beginDate = entity.getBeginDate();
            Date endDate = entity.getEndDate();
            if (beginDate != null && now.after(beginDate) && (endDate == null || now.before(endDate))) {
                bean.setStatus(PollStatus.VOTING);
            }
        }
        QuestionService questionService = this.getQuestionService();
        if (bean.getEntityId() != null) {
            List<QuestionBean> questions = questionService.getQuestionBeans(entity);
            bean.setQuestions(questions);
        }
        Date beginAddChoiceDate = null;
        Date endAddChoiceDate = null;
        boolean addChoiceEnabled = false;
        if (bean.getQuestions() != null) {
            for (QuestionBean question : bean.getQuestions()) {
                boolean bl = addChoiceEnabled = addChoiceEnabled || question.isChoiceAddAllowed();
                if (question.getBeginChoiceDate() != null && (beginAddChoiceDate == null || question.getBeginChoiceDate().before(beginAddChoiceDate))) {
                    beginAddChoiceDate = question.getBeginChoiceDate();
                }
                if (question.getEndChoiceDate() == null || endAddChoiceDate != null && !question.getEndChoiceDate().after(endAddChoiceDate)) continue;
                endAddChoiceDate = question.getEndChoiceDate();
            }
        }
        if (addChoiceEnabled && (beginAddChoiceDate == null && (endAddChoiceDate == null || now.before(endAddChoiceDate)) || beginAddChoiceDate != null && now.after(beginAddChoiceDate) && (endAddChoiceDate == null || now.before(endAddChoiceDate)))) {
            bean.setStatus(PollStatus.ADDING_CHOICES);
        }
        if (this.isNotPermitted(PollenPermissions.edit(entity))) {
            bean.setPermission(null);
            bean.setCreatorEmail(null);
        } else {
            ReportResumeBean report = this.getReportService().getReport(entity.getTopiaId());
            bean.setReport(report);
        }
        boolean commentIsVisible = entity.getTopiaId() != null && this.isPermitted(PollenPermissions.readComments(entity));
        bean.setCommentIsVisible(commentIsVisible);
        boolean voteIsVisible = entity.getTopiaId() != null && this.isPermitted(PollenPermissions.readVotes(entity));
        bean.setVoteIsVisible(voteIsVisible);
        boolean resultIsVisible = entity.getTopiaId() != null && this.isPermitted(PollenPermissions.readResult(entity));
        bean.setResultIsVisible(resultIsVisible);
        boolean canReadParticipants = entity.getTopiaId() != null && this.isPermitted(PollenPermissions.readParticipants(entity));
        bean.setParticipantsIsVisible(canReadParticipants);
        boolean canVote = entity.getTopiaId() != null && this.isPermitted(PollenPermissions.addVote(entity));
        bean.setCanVote(canVote);
        if (entity.isPersisted()) {
            if (commentIsVisible) {
                long commentCount = this.getCommentService().getCommentCount(entity);
                bean.setCommentCount(commentCount);
            }
            if (Polls.isPollRestricted(entity)) {
                long participantCount = this.getVoterListService().getVoterListMemberCount(entity);
                bean.setParticipantCount(participantCount);
                long participantInvitedCount = this.getVoterListService().getVoterListMemberInvitedCount(entity);
                bean.setParticipantInvitedCount(participantInvitedCount);
            }
        }
        bean.setGtuValidated(this.getGtuService().isGtuValidated(entity));
        bean.setMaxVoters(this.getMaxVoters(entity));
        if (creator != null && creator.getPollenUser() != null && creator.getPollenUser().getAvatar() != null) {
            bean.setCreatorAvatar(this.getPollenResourceService().getReduceIdByTopiaId(creator.getPollenUser().getAvatar().getTopiaId()));
        }
        return bean;
    }

    protected int getMaxVoters(Poll poll) {
        boolean premium = poll.isPremium() || this.getUserService().isPremium(poll.getCreator().getPollenUser());
        return premium ? 0 : this.getPollenServiceConfig().getMaxVoters();
    }

    @Deprecated
    public PaginationResult<PollBean> getPolls(PaginationParameter page, String search) {
        this.checkIsAdmin();
        PaginationParameter orderedPage = PollService.orderedPage(page, "title");
        PaginationResult polls = this.getPollDao().findAll(orderedPage, search);
        return polls.transform(this::toPollBean);
    }

    public PaginationResult<PollSummaryBean> searchPolls(PaginationParameter page, String search) {
        this.checkIsAdmin();
        PaginationParameter orderedPage = PollService.orderedPage(page, "title");
        PaginationResult polls = this.getPollDao().findAll(orderedPage, search);
        return polls.transform(this::toPollSummaryBean);
    }

    private PollSummaryBean toPollSummaryBean(Poll poll) {
        PollenEntityId<Poll> id = PollenEntityId.newId(Poll.class);
        id.setEntityId(poll.getTopiaId());
        id.encode();
        List questions = this.getQuestionDao().findAllByPollOrdered(poll);
        PollenPrincipal creator = poll.getCreator();
        Optional<Object> permission = this.isNotPermitted(PollenPermissions.edit(poll)) ? Optional.empty() : Optional.ofNullable(creator.getPermission()).map(PollenToken::getToken);
        PollStatus pollStatus = this.computePollStatus(poll, questions);
        Optional<String> creatorAvatar = Optional.ofNullable(creator.getPollenUser()).map(PollenUser::getAvatar).map(AbstractPollenEntity::getTopiaId).map(this.getPollenResourceService()::getReduceIdByTopiaId);
        long voteCount = this.getVoteService().getVoteCount((Question)questions.getFirst());
        Optional<OffsetDateTime> beginDate = Optional.ofNullable(poll.getBeginDate()).map(this::toOffsetDateTime);
        Optional<OffsetDateTime> endDate = Optional.ofNullable(poll.getEndDate()).map(this::toOffsetDateTime);
        Optional<String> picture = Optional.ofNullable(poll.getPicture()).map(AbstractPollenEntity::getTopiaId).map(this.getPollenResourceService()::getReduceIdByTopiaId);
        return new PollSummaryBean(id, poll.getTitle(), permission, pollStatus, creatorAvatar, creator.getName(), voteCount, Optional.ofNullable(poll.getDescription()), beginDate, endDate, picture, Optional.ofNullable(poll.getBuiltinPicture()));
    }

    private PollStatus computePollStatus(Poll poll, List<Question> questions) {
        Date now = this.getNow();
        if (Polls.isFinished(poll, now)) {
            return PollStatus.CLOSED;
        }
        PollStatus status = PollStatus.CREATED;
        if (Polls.isRunning(poll, now)) {
            status = PollStatus.VOTING;
        }
        if (Polls.isInAddChoicePeriod(questions, now)) {
            status = PollStatus.ADDING_CHOICES;
        }
        return status;
    }

    @Deprecated
    public PaginationResult<PollBean> getAllPolls(PaginationParameter page, String search, String filter) {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        PaginationParameter orderedPage = PollService.orderedPage(page, "title");
        PaginationResult polls = this.getPollDao().findAllUserPolls(connectedUser, orderedPage, search, filter);
        return polls.transform(this::toPollBean);
    }

    public PaginationResult<PollSummaryBean> searchAllPolls(PaginationParameter page, String search, String filter) {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        PaginationParameter orderedPage = PollService.orderedPage(page, "title");
        PaginationResult polls = this.getPollDao().findAllUserPolls(connectedUser, orderedPage, search, filter);
        return polls.transform(this::toPollSummaryBean);
    }

    @Deprecated
    public PaginationResult<PollBean> getCreatedPolls(PaginationParameter page, String search, String filter) {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        PaginationParameter orderedPage = PollService.orderedPage(page, "title");
        PaginationResult polls = this.getPollDao().findAllCreated(connectedUser, orderedPage, search, filter);
        return polls.transform(this::toPollBean);
    }

    public PaginationResult<PollSummaryBean> searchCreatedPolls(PaginationParameter page, String search, String filter) {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        PaginationParameter orderedPage = PollService.orderedPage(page, "title");
        PaginationResult polls = this.getPollDao().findAllCreated(connectedUser, orderedPage, search, filter);
        return polls.transform(this::toPollSummaryBean);
    }

    @Deprecated
    public PaginationResult<PollBean> getInvitedPolls(PaginationParameter page, String search, String filter) {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        PaginationParameter orderedPage = PollService.orderedPage(page, "title");
        PaginationResult polls = this.getPollDao().findAllInvited(connectedUser, orderedPage, search, filter);
        return polls.transform(this::toPollBean);
    }

    public PaginationResult<PollSummaryBean> searchInvitedPolls(PaginationParameter page, String search, String filter) {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        PaginationParameter orderedPage = PollService.orderedPage(page, "title");
        PaginationResult polls = this.getPollDao().findAllInvited(connectedUser, orderedPage, search, filter);
        return polls.transform(this::toPollSummaryBean);
    }

    @Deprecated
    public PaginationResult<PollBean> getParticipatedPolls(PaginationParameter page, String search, String filter) {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        PaginationParameter orderedPage = PollService.orderedPage(page, "title");
        PaginationResult polls = this.getPollDao().findAllParticipated(connectedUser, orderedPage, search, filter);
        return polls.transform(this::toPollBean);
    }

    public PaginationResult<PollSummaryBean> searchParticipatedPolls(PaginationParameter page, String search, String filter) {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        PaginationParameter orderedPage = PollService.orderedPage(page, "title");
        PaginationResult polls = this.getPollDao().findAllParticipated(connectedUser, orderedPage, search, filter);
        return polls.transform(this::toPollSummaryBean);
    }

    public PollBean getPoll(String pollId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPoll0(pollId);
        this.checkPermission(PollenPermissions.read(poll));
        return this.toPollBean(poll);
    }

    public PollBean getNewPoll(ChoiceType choiceType) {
        boolean premium;
        this.checkIsConnectedRequired();
        this.checkPermission(PollenPermissions.addPoll());
        PollBean pollBean = new PollBean();
        QuestionBean questionBean = new QuestionBean();
        PollenServicesConfig pollenServiceConfig = this.getPollenServiceConfig();
        VoteCountings voteCountingType = VoteCountings.forLegacyId((int)pollenServiceConfig.getDefaultVoteCountingType());
        questionBean.setVoteCountingType(voteCountingType.getLegacyId());
        questionBean.setVoteCountingConfig(this.getVoteCountingService().newConfig(voteCountingType));
        pollBean.addQuestion(questionBean);
        pollBean.setPollType(pollenServiceConfig.getDefaultPollType());
        pollBean.setVoteVisibility(pollenServiceConfig.getDefaultVoteVisibility());
        pollBean.setCommentVisibility(pollenServiceConfig.getDefaultCommentVisibility());
        pollBean.setResultVisibility(pollenServiceConfig.getDefaultResultVisibility());
        pollBean.setContinuousResults(pollenServiceConfig.getDefaultContinuousResults());
        pollBean.setVoteNotification(pollenServiceConfig.getDefaultVoteNotification());
        pollBean.setCommentNotification(pollenServiceConfig.getDefaultCommentNotification());
        pollBean.setNewChoiceNotification(pollenServiceConfig.getDefaultNewChoiceNotification());
        pollBean.setNotifyMeHoursBeforePollEnds(pollenServiceConfig.getDefaultNotifyMeHoursBeforePollEnds());
        PollenUser connectedUser = this.getConnectedUser();
        if (connectedUser != null) {
            pollBean.setCreatorName(connectedUser.getName());
            if (connectedUser.getDefaultEmailAddress() != null) {
                pollBean.setCreatorEmail(connectedUser.getDefaultEmailAddress().getEmailAddress());
            }
            pollBean.setGtuValidated(this.getGtuService().isGtuValidated(connectedUser));
        }
        pollBean.setMaxVoters((premium = this.getUserService().isPremium(connectedUser)) ? 0 : this.getPollenServiceConfig().getMaxVoters());
        return pollBean;
    }

    public PollenEntityRef<Poll> createPoll(PollBean poll) throws InvalidFormException {
        return this.createPoll(poll, Collections.emptyList(), Collections.emptyList());
    }

    public PollenEntityRef<Poll> createPoll(PollBean poll, List<VoterListBean> voterLists, List<VoterListMemberBean> voterListMembers) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkPermission(PollenPermissions.addPoll());
        this.checkNotNull(poll);
        this.checkIsNotPersisted(poll);
        ErrorMap errorMap = this.checkPoll(poll);
        errorMap.failIfNotEmpty();
        if (poll.getPollType() == PollType.RESTRICTED) {
            this.getVoterListService().checkVoters(null, voterLists, voterListMembers);
        }
        Poll savedPoll = this.savePoll(poll);
        if (poll.getPollType() == PollType.RESTRICTED) {
            this.getVoterListService().createVoters(savedPoll, voterLists, voterListMembers);
        }
        this.commit();
        this.getNotificationService().onPollCreated(savedPoll);
        return PollenEntityRef.of(savedPoll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollBean editPoll(PollBean poll) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(poll);
        this.checkIsPersisted(poll);
        Object object = PollService.getLock(poll.getEntityId());
        synchronized (object) {
            Poll pollDb = this.getPoll0(poll.getEntityId());
            this.checkPermission(PollenPermissions.edit(pollDb));
            ErrorMap errorMap = this.checkPoll(poll);
            errorMap.failIfNotEmpty();
            Poll savedPoll = this.savePoll(poll);
            this.commit();
            this.getNotificationService().onPollEdited(savedPoll);
            this.getFeedService().onPollEdited(savedPoll);
            return this.toPollBean(savedPoll);
        }
    }

    public void deletePoll(String pollId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPoll0(pollId);
        this.checkPermission(PollenPermissions.delete(poll));
        this.getPollDao().delete(poll);
        this.commit();
        this.getNotificationService().onPollDeleted(poll);
    }

    public PollenEntityRef<Poll> clonePoll(String pollId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPoll0(pollId);
        this.checkPermission(PollenPermissions.clone(poll));
        PollBean clonedPoll = this.toPollBean(poll);
        clonedPoll.setEntityId(null);
        clonedPoll.setPermission(null);
        clonedPoll.setBeginDate(this.serviceContext.getNow());
        clonedPoll.setEndDate(null);
        clonedPoll.setTitle(clonedPoll.getTitle() + " (clone)");
        List<ChoiceBean> clonedChoices = this.getChoiceService().getChoices(pollId);
        for (ChoiceBean choice : clonedChoices) {
            choice.setEntityId(null);
            choice.setPermission(null);
        }
        Poll savedPoll = this.savePoll(clonedPoll);
        this.commit();
        this.getNotificationService().onPollCreated(savedPoll);
        return PollenEntityRef.of(savedPoll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date closePoll(String pollId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Object object = PollService.getLock(pollId);
        synchronized (object) {
            Poll poll = this.getPoll0(pollId);
            this.checkPermission(PollenPermissions.close(poll));
            poll.setEndDate(this.getNow());
            this.commit();
            this.getNotificationService().onPollClosed(poll);
            this.getFeedService().onPollClosed(poll);
            return poll.getEndDate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenPoll(String pollId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Object object = PollService.getLock(pollId);
        synchronized (object) {
            Poll poll = this.getPoll0(pollId);
            this.checkPermission(PollenPermissions.close(poll));
            poll.setEndDate(null);
            this.commit();
            this.getNotificationService().onPollReopened(poll);
            this.getFeedService().onPollReopened(poll);
        }
    }

    public ExportBean exportPoll(String pollId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPoll0(pollId);
        this.checkPermission(PollenPermissions.export(poll));
        return null;
    }

    public PollBean assignPollToConnectedUser(String pollId) throws InvalidFormException {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        this.checkNotNull(pollId);
        Poll poll = this.getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        PollenUser creator = poll.getCreator().getPollenUser();
        ErrorMap errorMap = new ErrorMap();
        this.check(errorMap, "poll", creator == null || creator.equals((Object)connectedUser), I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.assign.already", (Object[])new Object[0]));
        errorMap.failIfNotEmpty();
        if (creator == null) {
            poll.getCreator().setPollenUser(connectedUser);
            this.commit();
        }
        return this.toPollBean(poll);
    }

    public Collection<Poll> getPollsWithReminderNeeded() {
        return this.getPollDao().findPollsWithReminderNeeded();
    }

    protected Poll savePoll(PollBean poll) {
        PollenUser connectedUser;
        ArrayList existingQuestions;
        Poll toSave;
        boolean pollExists = poll.isPersisted();
        if (pollExists) {
            toSave = this.getPoll0(poll.getEntityId());
            toSave.setVoteVisibility(poll.getVoteVisibility());
            toSave.setCommentVisibility(poll.getCommentVisibility());
            toSave.setResultVisibility(poll.getResultVisibility());
            toSave.setPollType(poll.getPollType());
            existingQuestions = this.getQuestionDao().findAllByPollOrdered(toSave);
        } else {
            PollenPrincipal creatorToPersist = this.getSecurityService().generatePollenPrincipal();
            connectedUser = this.getConnectedUser();
            if (connectedUser != null) {
                creatorToPersist.setPollenUser(connectedUser);
            } else if (this.getSecurityContext().getMainPrincipal().isEmpty()) {
                this.getSecurityContext().setMainPrincipal(creatorToPersist);
            }
            toSave = (Poll)this.getPollDao().newInstance();
            toSave.setVoteVisibility(poll.getVoteVisibility());
            toSave.setCommentVisibility(poll.getCommentVisibility());
            toSave.setResultVisibility(poll.getResultVisibility());
            toSave.setPollType(poll.getPollType());
            toSave.setCreator(creatorToPersist);
            this.getPollDao().create((PollenEntity)toSave);
            existingQuestions = new ArrayList();
        }
        toSave.getCreator().setName(poll.getCreatorName());
        toSave.getCreator().setEmail(poll.getCreatorEmail());
        toSave.setAnonymousVoteAllowed(poll.isAnonymousVoteAllowed());
        toSave.setContinuousResults(poll.isContinuousResults());
        toSave.setDescription(poll.getDescription());
        toSave.setTitle(poll.getTitle());
        toSave.setVoteNotification(poll.isVoteNotification());
        toSave.setCommentNotification(poll.isCommentNotification());
        toSave.setNewChoiceNotification(poll.isNewChoiceNotification());
        toSave.setNotifyMeHoursBeforePollEnds(poll.getNotifyMeHoursBeforePollEnds());
        toSave.setNotificationLocale(poll.getNotificationLocale());
        if (StringUtils.isNotBlank((CharSequence)poll.getPicture())) {
            toSave.setPicture(this.getPollenResourceService().getResource0(this.getPollenResourceService().getTopiaIdByReduceId(poll.getPicture())));
        }
        toSave.setBuiltinPicture(poll.getBuiltinPicture());
        toSave.setResultPresentation(poll.getResultPresentation());
        toSave.setBeginDate(poll.getBeginDate());
        toSave.setEndDate(poll.getEndDate());
        String suffixes = null;
        if (CollectionUtils.isNotEmpty(poll.getEmailAddressSuffixes())) {
            suffixes = poll.getEmailAddressSuffixes().stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(EMAIL_SUFFIX_SEPARATOR));
        }
        toSave.setEmailAddressSuffixes(suffixes);
        if (toSave.getBeginDate() == null) {
            toSave.setBeginDate(this.getNow());
        }
        if (toSave.getEndDate() != null && toSave.getNotifyMeHoursBeforePollEnds() > 0 && DateUtils.addHours((Date)new Date(), (int)toSave.getNotifyMeHoursBeforePollEnds()).before(toSave.getEndDate())) {
            toSave.setPollEndReminderSent(false);
        }
        if (CollectionUtils.isNotEmpty(poll.getQuestions())) {
            QuestionService questionService = this.getQuestionService();
            for (QuestionBean question : poll.getQuestions()) {
                Question persistedQuestion = questionService.saveQuestion(toSave, question);
                existingQuestions.remove(persistedQuestion);
            }
            if (CollectionUtils.isNotEmpty(existingQuestions)) {
                this.getQuestionDao().deleteAll(existingQuestions);
            }
        }
        if ((connectedUser = this.getConnectedUser()) == null) {
            if (!this.getGtuService().isGtuValidated(toSave) && poll.isGtuValidated()) {
                toSave.setGtuValidationDate(this.getNow());
            }
        } else if (!this.getGtuService().isGtuValidated(connectedUser) && poll.isGtuValidated()) {
            connectedUser.setGtuValidationDate(this.getNow());
        }
        return toSave;
    }

    protected Poll getPoll0(String pollId) {
        return (Poll)this.getPollDao().forTopiaIdEquals(pollId).findUnique();
    }

    protected ErrorMap checkPoll(PollBean poll) {
        ErrorMap errors = new ErrorMap();
        this.checkNotNull(errors, "pollType", poll.getPollType(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.pollType.mandatory", (Object[])new Object[0]));
        this.checkNotNull(errors, "commentVisibility", poll.getCommentVisibility(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.commentVisibility.mandatory", (Object[])new Object[0]));
        this.checkNotNull(errors, "voteVisibility", poll.getVoteVisibility(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.voteVisibility.mandatory", (Object[])new Object[0]));
        this.checkNotNull(errors, "resultVisibility", poll.getResultVisibility(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.resultVisibility.mandatory", (Object[])new Object[0]));
        this.checkNotBlank(errors, "title", poll.getTitle(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.title.mandatory", (Object[])new Object[0]));
        Date beginDate = poll.getBeginDate();
        if (beginDate == null) {
            beginDate = this.getNow();
        }
        if (poll.getEndDate() != null) {
            this.check(errors, "endDate", poll.getEndDate().compareTo(beginDate) > 0, I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.endDate.beforeBeginDate", (Object[])new Object[0]));
        }
        if (poll.getCreatorEmail() != null && !poll.getCreatorEmail().isEmpty()) {
            this.checkValidEmail(errors, "creator.email", poll.getCreatorEmail(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.creator.email.invalid", (Object[])new Object[0]));
        }
        this.checkQuestions(errors, poll.getQuestions());
        return errors;
    }

    protected void checkQuestions(ErrorMap errorMap, List<QuestionBean> questions) {
        boolean questionsNotEmpty = CollectionUtils.isNotEmpty(questions);
        this.check(errorMap, "questions", questionsNotEmpty, I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.choice.mandatory", (Object[])new Object[0]));
        if (questionsNotEmpty) {
            ArrayList<Question> existingQuestions = new ArrayList<Question>();
            for (int i = 0; i < questions.size(); ++i) {
                QuestionBean question = questions.get(i);
                ErrorMap questionErrors = this.getQuestionService().checkQuestion(existingQuestions, question);
                questionErrors.copyTo(errorMap, "questions[" + i + "].");
                existingQuestions.add(this.getQuestionService().toQuestion(question));
            }
        }
    }

    public Set<String> getInvalidEmails(String pollId) {
        HashSet invalidEmails = Sets.newHashSet();
        Poll poll = this.getPoll0(pollId);
        if (this.isPermitted(PollenPermissions.edit(poll))) {
            if (poll.getCreator().isInvalid()) {
                invalidEmails.add(poll.getCreator().getEmail());
            }
            if (Polls.isPollRestricted(poll)) {
                this.getVoterListMemberDao().forVoterList_PollEqualsAndMember_Invalid(poll).findAll().stream().map(voterListMember -> voterListMember.getMember().getEmail()).forEach(invalidEmails::add);
            }
        }
        return invalidEmails;
    }
}

