/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PollAbstract;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollType;
import org.chorem.pollen.business.persistence.PollVoteVisibility;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VotingList;

public class PollImpl
extends PollAbstract {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isPollFree() {
        return PollType.FREE == this.getPollType();
    }

    @Override
    public boolean isPollGroup() {
        return PollType.GROUP == this.getPollType();
    }

    @Override
    public boolean isPollRestricted() {
        return PollType.RESTRICTED == this.getPollType();
    }

    @Override
    public boolean isAnonymous() {
        return PollVoteVisibility.NOBODY == this.getPollVoteVisibility();
    }

    @Override
    public List<Vote> getVote() {
        if (this.vote == null) {
            this.vote = Lists.newArrayList();
        }
        return this.vote;
    }

    @Override
    public List<Choice> getChoice() {
        if (this.choice == null) {
            this.choice = Lists.newArrayList();
        }
        return this.choice;
    }

    @Override
    public List<Comment> getComment() {
        if (this.comment == null) {
            this.comment = Lists.newArrayList();
        }
        return this.comment;
    }

    @Override
    public List<PreventRule> getPreventRule() {
        if (this.preventRule == null) {
            this.preventRule = Lists.newArrayList();
        }
        return this.preventRule;
    }

    @Override
    public List<VotingList> getVotingList() {
        if (this.votingList == null) {
            this.votingList = Lists.newArrayList();
        }
        return this.votingList;
    }

    @Override
    public Vote getVoteByPollAccount(PollAccount account) {
        Preconditions.checkNotNull((Object)account);
        Vote resultVote = null;
        if (!this.isVoteEmpty()) {
            for (Vote vote : this.getVote()) {
                if (!account.equals(vote.getPollAccount())) continue;
                resultVote = vote;
                break;
            }
        }
        return resultVote;
    }

    @Override
    public String getAdminId() {
        return this.getVoteId(this.getCreator());
    }

    @Override
    public String getVoteId(PollAccount account) {
        String voteId = this.getPollId();
        if (account != null) {
            voteId = voteId + ":" + account.getAccountId();
        }
        return voteId;
    }

    @Override
    public boolean isStarted(Date currentDate) {
        return this.beginDate == null || this.beginDate.before(currentDate);
    }

    @Override
    public boolean isRunning(Date currentDate) {
        return !this.isClosed() && this.isStarted(currentDate) && !this.isFinished(currentDate);
    }

    @Override
    public boolean isFinished(Date currentDate) {
        return this.endDate != null && currentDate.after(this.endDate);
    }

    @Override
    public boolean isAddChoiceStarted(Date currentDate) {
        return this.isChoiceAddAllowed() && (this.beginChoiceDate == null || this.beginChoiceDate.before(currentDate));
    }

    @Override
    public boolean isAddChoiceRunning(Date currentDate) {
        return this.isChoiceAddAllowed() && !this.isClosed() && !this.isFinished(currentDate) && this.isAddChoiceStarted(currentDate) && !this.isAddChoiceFinished(currentDate);
    }

    @Override
    public boolean isAddChoiceFinished(Date currentDate) {
        return !this.isChoiceAddAllowed() || this.endChoiceDate != null && this.endChoiceDate.before(currentDate);
    }

    @Override
    public PreventRule getPreventRuleByScope(String scope) {
        Preconditions.checkNotNull((Object)scope);
        PreventRule rule = null;
        for (PreventRule value : this.getPreventRule()) {
            if (!scope.equals(value.getScope())) continue;
            rule = value;
            break;
        }
        return rule;
    }

    @Override
    public PersonToList getPersonToListByVote(Vote vote) {
        VotingList votingList;
        Preconditions.checkNotNull((Object)vote);
        PollAccount pollAccount = vote.getPollAccount();
        PersonToList personToList = null;
        Iterator<VotingList> i$ = this.getVotingList().iterator();
        while (i$.hasNext() && (personToList = (votingList = i$.next()).getPollAccountPersonToList(pollAccount)) == null) {
        }
        return personToList;
    }

    @Override
    public List<PollAccount> getPollAccounts(boolean withNoVote) {
        LinkedList pollAccounts = Lists.newLinkedList();
        for (VotingList votingList : this.getVotingList()) {
            for (PersonToList personToList : votingList.getPollAccountPersonToList()) {
                if (withNoVote && personToList.isHasVoted()) continue;
                pollAccounts.add(personToList.getPollAccount());
            }
        }
        return pollAccounts;
    }
}

