/*
 * #%L
 * Pollen :: Persistence
 * $Id: PollenFunctions.java 3698 2012-09-23 13:01:38Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.2/pollen-persistence/src/main/java/org/chorem/pollen/PollenFunctions.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen;

import com.google.common.base.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.nuiton.topia.persistence.TopiaEntity;

import java.util.Map;

/**
 * Usefull pollen functions.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenFunctions {

    public static final Function<TopiaEntity, String> ENTITY_BY_ID = new Function<TopiaEntity, String>() {
        @Override
        public String apply(TopiaEntity input) {
            return input.getTopiaId();
        }
    };

    public static final Function<UserAccount, String> USER_BY_LOGIN = new Function<UserAccount, String>() {
        @Override
        public String apply(UserAccount input) {
            return input.getLogin();
        }
    };

//    public static final Function<Poll, PollDTO> POLL_TO_BEAN = new Function<Poll, PollDTO>() {
//        @Override
//        public PollDTO apply(Poll input) {
//            PollDTO result = new PollDTO(input.getPollId());
//            result.setTitle(input.getTitle());
//            result.setDescription(input.getDescription());
//            result.setBeginChoiceDate(input.getBeginChoiceDate());
//            result.setBeginDate(input.getBeginDate());
//            result.setEndDate(input.getEndDate());
//            result.setAnonymous(input.isAnonymous());
//            result.setAnonymousVoteAllowed(input.isAnonymousVoteAllowed());
//            result.setPublicResults(input.isPublicResults());
//            result.setContinuousResults(input.isContinuousResults());
//            result.setChoiceAddAllowed(input.isChoiceAddAllowed());
//            result.setClosed(input.isClosed());
//            result.setCreatorId(input.getCreator().getVotingId());
//            result.setCreatorEmail(input.getCreator().getEmail());
//            result.setMaxChoiceNb(input.getMaxChoiceNb());
//            result.setPollType(input.getPollType());
//            result.setChoiceType(input.getChoiceType());
//            result.setVoteCounting(input.getVoteCountingType());
//
//            result.setComments(Lists.transform(input.getComment(),
//                                               COMMENT_TO_BEAN));
//
//            result.setChoices(Lists.transform(input.getChoice(),
//                                              CHOICE_TO_BEAN));
//
//            if (!input.isVotingListEmpty()) {
//
//                result.setVotingGroups(Lists.transform(input.getVotingList(),
//                                                       newVotingListToBean(input)
//                ));
//            } else {
//                // un groupe par défaut si il y en a pas
//                VotingGroupDTO group = new VotingGroupDTO("unique", 1);
//                group.setName("unique");
//                List<VotingPersonDTO> votes = Lists.transform(input.getVote(),
//                                                              VOTE_TO_BEAN);
//                group.setVotingPersons(votes);
//                result.getVotingGroups().add(group);
//            }
//            return result;
//        }
//    };
//
//    public static final Function<Comment, CommentDTO> COMMENT_TO_BEAN = new Function<Comment, CommentDTO>() {
//        @Override
//        public CommentDTO apply(Comment input) {
//            CommentDTO result = new CommentDTO(
//                    input.getAuthor(), input.getText());
//            return result;
//        }
//    };
//
//    public static final Function<Choice, PollChoiceDTO> CHOICE_TO_BEAN = new Function<Choice, PollChoiceDTO>() {
//        @Override
//        public PollChoiceDTO apply(Choice input) {
//            PollChoiceDTO result = new PollChoiceDTO(input.getTopiaId());
//            String choiceName = input.getName();
//            result.setName(choiceName);
//            result.setHidden(choiceName != null &&
//                             choiceName.startsWith(NumberMethod.HIDDEN_PREFIX));
//            result.setDescription(input.getDescription());
//            return result;
//        }
//    };
//
//    public static Function<VotingList, VotingGroupDTO> newVotingListToBean(final Poll poll) {
//        return new Function<VotingList, VotingGroupDTO>() {
//            @Override
//            public VotingGroupDTO apply(VotingList input) {
//                VotingGroupDTO result = new VotingGroupDTO(
//                        input.getTopiaId(),
//                        input.getWeight());
//
//                result.setName(input.getName());
//
//                for (PersonToList pToList : input.getPollAccountPersonToList()) {
//                    Vote vote = poll.getVoteByPollAccount(pToList.getPollAccount());
//                    if (vote != null) {
//                        // Pas de vote pour cette personne : doit engendrer erreur ?!?
//                        VotingPersonDTO bean = VOTE_TO_BEAN.apply(vote);
//                        result.getVotingPersons().add(bean);
//                    }
//                }
//                return result;
//            }
//        };
//    }

//    public static final Function<VotingList, VotingGroupDTO> VOTING_LIST_TO_BEAN = new Function<VotingList, VotingGroupDTO>() {
//        @Override
//        public VotingGroupDTO apply(VotingList input) {
//            VotingGroupDTO result = new VotingGroupDTO(
//                    input.getTopiaId(),
//                    input.getWeight());
//
//            result.setName(input.getName());
//
//            for (PersonToList pToList : input.getPollAccountPersonToList()) {
//                Vote vote = input.getPoll().getVoteByPollAccount(pToList.getPollAccount());
//                if (vote != null) {
//                    // Pas de vote pour cette personne : doit engendrer erreur ?!?
//                    VotingPersonDTO bean = VOTE_TO_BEAN.apply(vote);
//                    result.getVotingPersons().add(bean);
//                }
//            }
//            return result;
//        }
//    };

    public static final Function<Vote, PollAccount> VOTE_TO_POLL_ACCOUNT = new Function<Vote, PollAccount>() {
        @Override
        public PollAccount apply(Vote input) {
            PollAccount result = input.getPollAccount();
            return result;
        }
    };

//    public static final Function<Vote, VotingPersonDTO> VOTE_TO_BEAN = new Function<Vote, VotingPersonDTO>() {
//        @Override
//        public VotingPersonDTO apply(Vote input) {
//            VotingPersonDTO result =
//                    new VotingPersonDTO(input.getPollAccount().getVotingId(), input.getWeight());
//            result.setEmail(input.getPollAccount().getEmail());
//
//            if (!input.isChoiceVoteToChoiceEmpty()) {
//                for (VoteToChoice vToChoice : input.getChoiceVoteToChoice()) {
//                    if (vToChoice != null && vToChoice.getChoice() != null) {
//                        VoteToChoiceDTO bean = VOTE_TO_CHOICE_TO_BEAN.apply(vToChoice);
//                        result.getChoices().add(bean);
//                    }
//                }
//            }
//            return result;
//        }
//    };
//
//    public static final Function<VoteToChoice, VoteToChoiceDTO> VOTE_TO_CHOICE_TO_BEAN = new Function<VoteToChoice, VoteToChoiceDTO>() {
//        @Override
//        public VoteToChoiceDTO apply(VoteToChoice input) {
//            VoteToChoiceDTO result = new VoteToChoiceDTO(
//                    input.getChoice().getTopiaId(),
//                    input.getVoteValue());
//
//            return result;
//        }
//    };

    public static final Function<Map.Entry<Poll, PollAccount>, Pair<Poll, PollAccount>> MAP_ENTRY_TO_PAIR_FUNCTION = new Function<Map.Entry<Poll, PollAccount>, Pair<Poll, PollAccount>>() {
        @Override
        public Pair<Poll, PollAccount> apply(Map.Entry<Poll, PollAccount> input) {
            return Pair.of(input.getKey(), input.getValue());
        }
    };
}
