/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.List;

import org.chorem.pollen.business.dto.PersonListDTO;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.nuiton.topia.TopiaException;

/**
 * Conversion des dtos PersonList en entités et vice-versa.
 *
 * @author tcicognani
 * @author rannou
 * @version $Id: DataPersonListConverter.java 2615 2009-07-01 13:47:45Z nrannou
 *          $
 */
public class DataPersonListConverter extends DataConverter {

    /**
     * Création d'une liste à partir d'un dto liste.
     *
     * @param ePersonList L'entité liste.
     * @param personListDTO le dto liste.
     */
    public void populatePersonListEntity(PersonListDTO personListDTO,
            PersonList ePersonList) throws TopiaException {
        ePersonList.setName(personListDTO.getName());

        if (personListDTO.getUserId().length() > 0) {
            UserAccountDAO userDAO = PollenModelDAOHelper
                    .getUserAccountDAO(super.transaction);
            UserAccount userAccountEntity = userDAO.findByTopiaId(personListDTO
                    .getUserId());
            ePersonList.setOwner(userAccountEntity);
        }
    }

    /**
     * Création d'un dto liste à partir d'une liste.
     *
     * @param ePersonList L'entité liste.
     * @return le dto liste.
     */
    public PersonListDTO createPersonListDTO(PersonList ePersonList) {
        PersonListDTO personListDTO = new PersonListDTO();
        personListDTO.setId(ePersonList.getTopiaId());
        personListDTO.setName(ePersonList.getName());

        if (ePersonList.getOwner() != null) {
            personListDTO.setUserId(ePersonList.getOwner().getTopiaId());
        }
        if (ePersonList.getPollAccount().size() > 0) {
            DataPollAccountConverter converter = new DataPollAccountConverter();
            personListDTO.setPollAccountDTOs(converter
                    .createPollAccountDTOs(ePersonList.getPollAccount()));
        }

        return personListDTO;
    }

    /**
     * Création d'une liste de dtos personList à partir d'une liste d'entité
     * personList.
     *
     * @param lPersonLists liste d'entités personList
     * @return la liste des dtos personList
     */
    public List<PersonListDTO> createPersonListDTOs(
            List<PersonList> lPersonLists) {
        ArrayList<PersonListDTO> results = new ArrayList<PersonListDTO>();
        PersonListDTO dto;
        for (PersonList l : lPersonLists) {
            dto = this.createPersonListDTO(l);
            results.add(dto);
        }
        return results;
    }
}
