/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Result}.
 */
public abstract class ResultAbstract extends TopiaEntityAbstract implements Result {

    public String name;

    public String ResultValue;

    public Boolean byGroup;

    public Poll poll;

    public VoteCounting voteCounting;

    /**
     * Constructeur de ResultAbstract par défaut.
     */
    public ResultAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Result.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Result.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "ResultValue", String.class, ResultValue);
        visitor.visit(this, "byGroup", Boolean.class, byGroup);
        visitor.visit(this, "poll", Poll.class, poll);
        visitor.visit(this, "voteCounting", VoteCounting.class, voteCounting);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Result#setName(String)
     */
    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Result#getName()
     */
    @Override
    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
    }

    /* (non-Javadoc)
     * @see Result#setResultValue(String)
     */
    @Override
    public void setResultValue(String value) {
        String _oldValue = this.ResultValue;
        fireOnPreWrite("ResultValue", _oldValue, value);
        this.ResultValue = value;
        fireOnPostWrite("ResultValue", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Result#getResultValue()
     */
    @Override
    public String getResultValue() {
        fireOnPreRead("ResultValue", ResultValue);
        String result = this.ResultValue;
        fireOnPostRead("ResultValue", ResultValue);
        return result;
    }

    /* (non-Javadoc)
     * @see Result#setByGroup(Boolean)
     */
    @Override
    public void setByGroup(Boolean value) {
        Boolean _oldValue = this.byGroup;
        fireOnPreWrite("byGroup", _oldValue, value);
        this.byGroup = value;
        fireOnPostWrite("byGroup", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Result#getByGroup()
     */
    @Override
    public Boolean getByGroup() {
        fireOnPreRead("byGroup", byGroup);
        Boolean result = this.byGroup;
        fireOnPostRead("byGroup", byGroup);
        return result;
    }

    /* (non-Javadoc)
     * @see Result#setPoll(Poll)
     */
    @Override
    public void setPoll(Poll value) {
        Poll _oldValue = this.poll;
        fireOnPreWrite("poll", _oldValue, value);
        this.poll = value;
        fireOnPostWrite("poll", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Result#getPoll()
     */
    @Override
    public Poll getPoll() {
        fireOnPreRead("poll", poll);
        Poll result = this.poll;
        fireOnPostRead("poll", poll);
        return result;
    }

    /* (non-Javadoc)
     * @see Result#setVoteCounting(VoteCounting)
     */
    @Override
    public void setVoteCounting(VoteCounting value) {
        VoteCounting _oldValue = this.voteCounting;
        fireOnPreWrite("voteCounting", _oldValue, value);
        this.voteCounting = value;
        fireOnPostWrite("voteCounting", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Result#getVoteCounting()
     */
    @Override
    public VoteCounting getVoteCounting() {
        fireOnPreRead("voteCounting", voteCounting);
        VoteCounting result = this.voteCounting;
        fireOnPostRead("voteCounting", voteCounting);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("ResultValue", this.ResultValue).
            append("byGroup", this.byGroup).
            append("voteCounting", this.voteCounting).
         toString();
        return result;
    }
        
} //ResultAbstract
