/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.List;

import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonListDAO;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.nuiton.topia.TopiaException;

/**
 * Gestion de la conversion des dtos pollAccount en entité et vice-versa.
 *
 * @author kmorin
 * @version $Id: DataPollAccountConverter.java 2652 2009-07-17 08:10:26Z nrannou
 *          $
 */
public class DataPollAccountConverter extends DataConverter {

    /**
     * Création d'un compte à partir d'un dto compte.
     *
     * @param pollAccountDTO le dto compte
     * @param ePollAccount l'entité compte
     * @throws TopiaException
     */
    public void populatePollAccountEntity(PollAccountDTO pollAccountDTO,
            PollAccount ePollAccount) throws TopiaException {
        ePollAccount.setAccountId(pollAccountDTO.getAccountId());
        ePollAccount.setEmail(pollAccountDTO.getEmail());
        ePollAccount.setVotingId(pollAccountDTO.getVotingId());

        if (pollAccountDTO.getUserId().length() > 0) {
            UserAccountDAO userAccountDAO = PollenModelDAOHelper
                    .getUserAccountDAO(super.transaction);
            UserAccount userAccountEntity = userAccountDAO
                    .findByTopiaId(pollAccountDTO.getUserId());
            ePollAccount.setUserAccount(userAccountEntity);
        }
        if (pollAccountDTO.getPersonListId().length() > 0) {
            PersonListDAO personListDAO = PollenModelDAOHelper
                    .getPersonListDAO(super.transaction);
            PersonList personListEntity = personListDAO
                    .findByTopiaId(pollAccountDTO.getPersonListId());
            ePollAccount.setPersonList(personListEntity);
        }

        // Conversion des PersonToList
        if (ePollAccount.getVotingListPersonToList() != null) {
            for (PersonToList personToList : ePollAccount
                    .getVotingListPersonToList()) {
                personToList.setWeight(pollAccountDTO.getWeight());
                personToList.setHasVoted(pollAccountDTO.isHasVoted());
                //votingLists
            }
        }
    }

    /**
     * Création d'un compte à partir de ses attributs.
     *
     * @param votingId le votingId
     * @param email l'email
     * @param ePollAccount l'entité compte
     * @throws TopiaException
     */
    public void populatePollAccountEntity(String votingId, String email,
            String userId, PollAccount ePollAccount) throws TopiaException {
        ePollAccount.setEmail(email);
        ePollAccount.setVotingId(votingId);

        if (userId != null && userId.length() > 0) {
            UserAccountDAO userAccountDAO = PollenModelDAOHelper
                    .getUserAccountDAO(super.transaction);
            UserAccount userAccountEntity = userAccountDAO
                    .findByTopiaId(userId);
            ePollAccount.setUserAccount(userAccountEntity);
        }
    }

    /**
     * Création d'un dto pollAccount à partir d'une entité.
     *
     * @param ePollAccount l'entité
     * @return le dto PollAccount
     */
    public PollAccountDTO createPollAccountDTO(PollAccount ePollAccount) {
        PollAccountDTO dto = new PollAccountDTO();
        dto.setId(ePollAccount.getTopiaId());
        dto.setAccountId(ePollAccount.getAccountId());
        dto.setEmail(ePollAccount.getEmail());
        dto.setVotingId(ePollAccount.getVotingId());

        if (ePollAccount.getUserAccount() != null) {
            dto.setUserId(ePollAccount.getUserAccount().getTopiaId());
        }
        if (ePollAccount.getPersonList() != null) {
            dto.setPersonListId(ePollAccount.getPersonList().getTopiaId());
        }

        if (ePollAccount.getVote().size() > 0) {
            DataVoteConverter voteConverter = new DataVoteConverter();
            dto.setVoteDTOs(voteConverter
                    .createVoteDTOs(ePollAccount.getVote()));
        }

        // Conversion des PersonToList
        if (ePollAccount.getVotingListPersonToList() != null) {
            //DataVotingListConverter votingListConverter = new DataVotingListConverter();
            for (PersonToList personToList : ePollAccount
                    .getVotingListPersonToList()) {
                //VotingListDTO votingListDTO = votingListConverter.createVotingListDTO(personToList.getVotingList());

                dto.setWeight(personToList.getWeight());
                dto.setHasVoted(personToList.getHasVoted());
                //dto.setVotingListId(votingListDTO.getId());
            }
        }

        return dto;
    }

    /**
     * Retourne une liste de dtos pollAccount à partir d'une liste d'entités.
     *
     * @param lPollAccounts liste de entités pollAccount
     * @return la liste des dtos pollAccount
     */
    public List<PollAccountDTO> createPollAccountDTOs(
            List<PollAccount> lPollAccounts) {
        ArrayList<PollAccountDTO> results = new ArrayList<PollAccountDTO>();
        PollAccountDTO dto;
        for (PollAccount p : lPollAccounts) {
            dto = this.createPollAccountDTO(p);
            results.add(dto);
        }
        return results;
    }
}