/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité Choice.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class ChoiceDAOAbstract<E extends Choice> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)Choice.class;
    }

    public void delete(E entity) throws TopiaException {
        
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut name
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return un element ou null
     */
    public E findByName(java.lang.String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return une liste
     */
    public List<E> findAllByName(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }
    /**
     * Recherche sur l'attribut description
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return un element ou null
     */
    public E findByDescription(java.lang.String v) throws TopiaException {
        E result = findByProperty("description", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return une liste
     */
    public List<E> findAllByDescription(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("description", v);
        return result;
    }
    /**
     * Recherche sur l'attribut validate
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * validate le paramètre
     * @param v la valeur que doit avoir validate
     * @return un element ou null
     */
    public E findByValidate(java.lang.Boolean v) throws TopiaException {
        E result = findByProperty("validate", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * validate le paramètre
     * @param v la valeur que doit avoir validate
     * @return une liste
     */
    public List<E> findAllByValidate(java.lang.Boolean v) throws TopiaException {
        List<E> result = findAllByProperty("validate", v);
        return result;
    }
    /**
     * Recherche sur l'attribut vote
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * vote contient le paramètre
     * @param v la valeur que doit contenir vote
     * @return un element ou null
     */
    public E findContainsVote(org.chorem.pollen.business.persistence.Vote ... v) throws TopiaException {
        E result = findContainsProperties("vote", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * vote contient le paramètre
     * @param v la valeur que doit contenir vote
     * @return une liste
     */
    public List<E> findAllContainsVote(org.chorem.pollen.business.persistence.Vote ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("vote", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut poll
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * poll le paramètre
     * @param v la valeur que doit avoir poll
     * @return un element ou null
     */
    public E findByPoll(org.chorem.pollen.business.persistence.Poll v) throws TopiaException {
        E result = findByProperty("poll", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * poll le paramètre
     * @param v la valeur que doit avoir poll
     * @return une liste
     */
    public List<E> findAllByPoll(org.chorem.pollen.business.persistence.Poll v) throws TopiaException {
        List<E> result = findAllByProperty("poll", v);
        return result;
    }

} // ChoiceDAOAbstract
