/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business;

import org.chorem.pollen.business.dto.UserDTO;

/**
 * Interface du service d'authentification.
 *
 * @author kmorin
 * @version $Id: ServiceAuth.java 2613 2009-06-30 13:32:57Z nrannou $
 */
public interface ServiceAuth {

    /**
     * Identification d'un utilisateur
     *
     * @param login loin de l'utilisateur qui s'authentifie
     * @param password le password entré par l'utilisateur
     * @return l'utilisateur dont le login est login
     */
    public UserDTO isLoginRight(String login, String password);
}