/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.web.service;

import com.google.common.collect.Lists;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaTechnicalException;
import org.chorem.lima.beans.DocumentReport;
import org.chorem.lima.beans.FinancialStatementAmounts;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.business.LimaServiceConfig;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.ClosedPeriodicEntryBookService;
import org.chorem.lima.business.api.EntryService;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FinancialStatementService;
import org.chorem.lima.business.api.IdentityService;
import org.chorem.lima.business.api.ReportService;
import org.chorem.lima.business.api.VatStatementService;
import org.chorem.lima.business.api.report.BalanceReportService;
import org.chorem.lima.business.api.report.GeneralEntryBookReportService;
import org.chorem.lima.business.api.report.LedgerReportService;
import org.chorem.lima.business.api.report.ProvisionalEntryBookReportService;
import org.chorem.lima.business.utils.BigDecimalToString;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.Identity;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.web.action.ReportBuilder;
import org.chorem.lima.web.utils.DocumentsEnum;
import org.nuiton.i18n.I18n;

public class DocumentService {
    protected static final Log log = LogFactory.getLog(DocumentService.class);
    private IdentityService identityService;
    private FinancialStatementService financialStatementService;
    private ReportService reportService;
    private VatStatementService vatStatementService;
    protected BalanceReportService balanceReportService;
    protected GeneralEntryBookReportService generalEntryBookReportService;
    protected ProvisionalEntryBookReportService entryBookReportService;
    protected LedgerReportService ledgerReportService;
    protected ClosedPeriodicEntryBookService closedPeriodicEntryBookService;
    protected FinancialPeriodService financialPeriodService;
    protected EntryService entryService;
    protected ReportBuilder reportBuilder;
    protected AccountService accountService;
    protected String path = LimaServiceConfig.getInstance().getReportsModelDir().getAbsolutePath();
    protected final String BALANCE_FILE_PATH = this.path + File.separator + DocumentsEnum.BALANCE.getFileName() + ".pdf";
    protected final String GENERAL_ENTRY_BOOK_REPORT_PDF_FILE_PATH = this.path + File.separator + DocumentsEnum.GENERAL_ENTRY_BOOK.getFileName() + ".pdf";
    protected final String ENTRY_BOOKS_REPORT_PDF_FILE_PATH = this.path + File.separator + DocumentsEnum.ENTRY_BOOKS.getFileName() + ".pdf";
    protected final String LEDGER_REPORT_PDF_FILE_PATH = this.path + File.separator + DocumentsEnum.LEDGER.getFileName() + ".pdf";

    public DocumentService() {
        this.identityService = (IdentityService)LimaServiceFactory.getService(IdentityService.class);
        this.financialStatementService = (FinancialStatementService)LimaServiceFactory.getService(FinancialStatementService.class);
        this.reportService = (ReportService)LimaServiceFactory.getService(ReportService.class);
        this.vatStatementService = (VatStatementService)LimaServiceFactory.getService(VatStatementService.class);
        this.closedPeriodicEntryBookService = (ClosedPeriodicEntryBookService)LimaServiceFactory.getService(ClosedPeriodicEntryBookService.class);
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
        this.entryService = (EntryService)LimaServiceFactory.getService(EntryService.class);
        this.accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);
        this.balanceReportService = (BalanceReportService)LimaServiceFactory.getService(BalanceReportService.class);
        this.generalEntryBookReportService = (GeneralEntryBookReportService)LimaServiceFactory.getService(GeneralEntryBookReportService.class);
        this.entryBookReportService = (ProvisionalEntryBookReportService)LimaServiceFactory.getService(ProvisionalEntryBookReportService.class);
        this.ledgerReportService = (LedgerReportService)LimaServiceFactory.getService(LedgerReportService.class);
        this.reportBuilder = new ReportBuilder();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Path : " + this.path));
        }
    }

    public String createFinancialStatementsDocuments(Date beginDate, Date endDate) {
        List financialStatementAmounts = this.financialStatementService.financialStatementReport(beginDate, endDate);
        String financialReport = "";
        try {
            financialReport = this.constructHtmlHeader("");
            ArrayList listList = new ArrayList();
            Boolean first = true;
            int min = 0;
            int size = financialStatementAmounts.size();
            for (int i = 0; i < size; ++i) {
                FinancialStatementAmounts fStatementAmounts = (FinancialStatementAmounts)financialStatementAmounts.get(i);
                if (fStatementAmounts.getLevel() != 1 || fStatementAmounts.isSubAmount()) continue;
                if (first.booleanValue()) {
                    first = false;
                } else {
                    listList.add(financialStatementAmounts.subList(min, i - 1));
                }
                min = i;
            }
            listList.add(financialStatementAmounts.subList(min, size));
            int printedType = -1;
            for (List list : listList) {
                if (list.isEmpty()) continue;
                String title = ((FinancialStatementAmounts)list.get(0)).getLabel();
                int n = list.size();
                ++printedType;
                for (int i = 0; i < n; i += n) {
                    String[] columnHeaderTable;
                    financialReport = financialReport + this.constructHeaderTitle(title, beginDate, endDate);
                    String boldBegin = "<b>";
                    String boldEnd = "</b>";
                    financialReport = financialReport + "<table border=\"1\" width=\"100%\" cellpadding=\"3\" cellspacing=\"0\">\n<tr align=\"center\">\n";
                    if (printedType == 0) {
                        columnHeaderTable = new String[]{boldBegin + I18n.t((String)"lima-business.document.label", (Object[])new Object[0]) + boldEnd, boldBegin + I18n.t((String)"lima-business.document.grossamount", (Object[])new Object[0]) + boldEnd, boldBegin + I18n.t((String)"lima-business.document.provisiondeprecationamount", (Object[])new Object[0]) + boldEnd, boldBegin + I18n.t((String)"lima-business.document.netamount", (Object[])new Object[0]) + boldEnd};
                        financialReport = financialReport + this.constructTableLine(columnHeaderTable);
                    } else {
                        columnHeaderTable = new String[]{boldBegin + I18n.t((String)"lima-business.document.label", (Object[])new Object[0]) + boldEnd, boldBegin + I18n.t((String)"lima-business.document.amount", (Object[])new Object[0]) + boldEnd};
                        financialReport = financialReport + this.constructTableLine(columnHeaderTable);
                    }
                    for (FinancialStatementAmounts financialStatementAmount : list) {
                        String[] columns;
                        BigDecimal provisionDeprecationAmount;
                        String label = financialStatementAmount.getLabel();
                        int level = financialStatementAmount.getLevel();
                        BigDecimal grossAmount = financialStatementAmount.getGrossAmount();
                        if (grossAmount == null) {
                            grossAmount = BigDecimal.ZERO;
                        }
                        if ((provisionDeprecationAmount = financialStatementAmount.getProvisionDeprecationAmount()) == null) {
                            provisionDeprecationAmount = BigDecimal.ZERO;
                        }
                        if (label == null) {
                            String[] emptyColumn;
                            if (printedType == 0) {
                                emptyColumn = new String[]{"", "", "", ""};
                                financialReport = financialReport + this.constructTableLine(emptyColumn);
                                continue;
                            }
                            emptyColumn = new String[]{"", ""};
                            financialReport = financialReport + this.constructTableLine(emptyColumn);
                            continue;
                        }
                        StringBuilder tab = new StringBuilder();
                        for (int k = 0; k < level; ++k) {
                            tab.append("\t");
                        }
                        String tabLabel = "";
                        tabLabel = financialStatementAmount.isHeader() ? boldBegin + tab + label + boldEnd : tab + label;
                        String grossAmountStr = "";
                        if (!grossAmount.equals(BigDecimal.ZERO)) {
                            grossAmountStr = grossAmount.toString();
                        }
                        String provisionDeprecationAmountStr = "";
                        if (!provisionDeprecationAmount.equals(BigDecimal.ZERO)) {
                            provisionDeprecationAmountStr = provisionDeprecationAmount.toString();
                        }
                        BigDecimal solde = grossAmount;
                        solde = solde.subtract(provisionDeprecationAmount);
                        String soldeStr = "";
                        if (!solde.equals(BigDecimal.ZERO)) {
                            soldeStr = solde.toString();
                        }
                        if (printedType == 0) {
                            columns = new String[]{tabLabel, grossAmountStr, provisionDeprecationAmountStr, soldeStr};
                            financialReport = financialReport + this.constructTableLine(columns);
                            continue;
                        }
                        columns = new String[]{tabLabel, soldeStr};
                        financialReport = financialReport + this.constructTableLine(columns);
                    }
                    financialReport = financialReport + "</table>";
                }
            }
            financialReport = financialReport + "</body></html>";
        }
        catch (Exception ex) {
            throw new LimaTechnicalException("Can't create document", (Throwable)ex);
        }
        return financialReport;
    }

    public String createAccountDocument(Date beginDate, Date endDate, String account) {
        String accountReport = null;
        try {
            Account accountFormat = this.accountService.findAccountById(account);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMMMM yyyy");
            accountReport = this.constructHtmlHeader(I18n.t((String)"lima.reports.accounts", (Object[])new Object[0]));
            if (beginDate != null && endDate != null && accountFormat != null) {
                String subTitleFirstpart = I18n.t((String)"lima.fiscalperiod.fiscalperiod", (Object[])new Object[0]) + " : " + simpleDateFormat.format(beginDate) + " - " + simpleDateFormat.format(endDate);
                String subTitleSecPart = I18n.t((String)"lima.financialtransaction.account", (Object[])new Object[0]) + " : " + accountFormat.getAccountNumber() + " - " + accountFormat.getLabel();
                accountReport = accountReport + this.constructSubTitleHtml(subTitleFirstpart, subTitleSecPart);
                ReportsDatas results = this.reportService.generateAccountsReports(accountFormat, Boolean.valueOf(true), beginDate, endDate);
                List entries = results.getListEntry();
                String[] columnNames = new String[]{I18n.t((String)"lima.table.number", (Object[])new Object[0]), I18n.t((String)"lima.table.date", (Object[])new Object[0]), I18n.t((String)"lima.table.entrybook", (Object[])new Object[0]), I18n.t((String)"lima.table.voucher", (Object[])new Object[0]), I18n.t((String)"lima.table.description", (Object[])new Object[0]), I18n.t((String)"lima.table.letter", (Object[])new Object[0]), I18n.t((String)"lima.table.debit", (Object[])new Object[0]), I18n.t((String)"lima.table.credit", (Object[])new Object[0])};
                accountReport = accountReport + "\t<table border=\"1\" width=\"100%\" cellpadding=\"3\" cellspacing=\"0\">\n";
                accountReport = accountReport + this.constructTableHeader(columnNames);
                accountReport = accountReport + "\t\t<tbody>\n";
                boolean even = true;
                for (Entry entry : entries) {
                    String accountNumber = entry.getAccount().getAccountNumber();
                    String transactionDate = simpleDateFormat.format(entry.getFinancialTransaction().getTransactionDate());
                    String code = "";
                    if (entry.getFinancialTransaction().getEntryBook() != null) {
                        code = entry.getFinancialTransaction().getEntryBook().getCode();
                    }
                    String voucher = entry.getVoucher();
                    String description = entry.getDescription();
                    String lettering = entry.getLettering();
                    String[] columnData = new String[]{StringUtils.isBlank((CharSequence)accountNumber) ? "" : accountNumber, StringUtils.isBlank((CharSequence)transactionDate) ? "" : transactionDate, StringUtils.isBlank((CharSequence)code) ? "" : code, StringUtils.isBlank((CharSequence)voucher) ? "" : voucher, StringUtils.isBlank((CharSequence)description) ? "" : description, StringUtils.isBlank((CharSequence)lettering) ? "" : lettering, (entry.isDebit() ? entry.getAmount() : BigDecimal.ZERO).toString(), (entry.isDebit() ? BigDecimal.ZERO : entry.getAmount()).toString()};
                    accountReport = accountReport + this.constructTableLine(columnData, even);
                    even = !even;
                }
                accountReport = accountReport + "\t\t</tbody>\n\t</table>\n</body>\n";
            } else {
                JOptionPane.showMessageDialog(null, I18n.t((String)"lima.reports.account.noaccount", (Object[])new Object[0]), I18n.t((String)"lima.reports.account.noaccounttitle", (Object[])new Object[0]), 1);
            }
            accountReport = accountReport + "</html>";
        }
        catch (Exception e) {
            throw new LimaTechnicalException("Can't create document", (Throwable)e);
        }
        return accountReport;
    }

    protected String constructHtmlHeader(String title) {
        String head = "<!DOCTYPE html>\n<html>\n<head>\n\t<meta charset=\"UTF-8\" />\n\t<title>" + title + "</title>\n" + "</head>\n" + "<body>\n" + "\t<h1>" + title + "</h1>\n";
        return head;
    }

    protected String constructSubTitleHtml(String subTitle) {
        return "\t<h2>" + subTitle + "</h2>\n";
    }

    protected String constructSubTitleHtml(String subTitleFirstpart, String subTitleSecPart) {
        String subTitle = "\t<h2>\n" + subTitleFirstpart + "<br/>\n" + subTitleSecPart + "</h2>\n";
        return subTitle;
    }

    protected String constructTableHeader(String[] columnsNames) {
        String header = "\t\t<thead>\n\t\t\t<tr>\n";
        for (String name : columnsNames) {
            header = header + "\t\t\t\t<th>" + name + "</th>\n";
        }
        header = header + "\t\t\t</tr>\t\t\n</thead>\n";
        return header;
    }

    protected String constructTableLine(String[] cells, boolean even) {
        String style = even ? "line_even" : "line_odd";
        String line = "\t\t<tr class=\"" + style + "\">\n";
        for (String cell : cells) {
            line = line + "\t\t\t<td>" + cell + "</td>\n";
        }
        line = line + "\t\t</tr>\n";
        return line;
    }

    protected String constructTableLine(String[] cells) {
        String line = "\t\t<tr>\n";
        for (String cell : cells) {
            line = line + "\t\t\t<td>" + cell + "</td>\n";
        }
        line = line + "\t\t</tr>\n";
        return line;
    }

    protected String constructHeaderTitle(String title, Date beginDate, Date endDate) {
        Identity identity = this.identityService.getIdentity();
        String headerTitle = "<table><thead> <tr><th>" + title + "</th></tr>" + "</thead>" + "<tr> " + "<td>" + "<table align=\"left\" border=\"1\" cellpadding=\"3\" cellspacing=\"0\" style=\"font-size:13px;\" >\n" + "<tr>\n";
        String boldItalicBegin = "<b><i>";
        String boldItalicEnd = "</i></b>";
        if (identity != null) {
            String[] columnsNameSociety = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.society", (Object[])new Object[0]) + boldItalicEnd, "<i>" + (StringUtils.isNotEmpty((CharSequence)identity.getName()) ? identity.getName() : " - ") + "</i>"};
            headerTitle = headerTitle + this.constructTableLine(columnsNameSociety);
            String[] columnsDescription = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.description", (Object[])new Object[0]) + boldItalicEnd, "<i>" + (StringUtils.isNotEmpty((CharSequence)identity.getDescription()) ? identity.getDescription() : " - ") + "</i>"};
            headerTitle = headerTitle + this.constructTableLine(columnsDescription);
            String[] columnsAdressOne = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.adress", (Object[])new Object[0]) + boldItalicEnd, "<i>" + (StringUtils.isNotEmpty((CharSequence)identity.getAddress()) ? identity.getAddress() : " - ") + "</i>"};
            headerTitle = headerTitle + this.constructTableLine(columnsAdressOne);
            String[] columnsAdressTwo = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.adresssuite", (Object[])new Object[0]) + boldItalicEnd, "<i>" + (StringUtils.isNotEmpty((CharSequence)identity.getAddress2()) ? identity.getAddress2() : " - ") + "</i>"};
            headerTitle = headerTitle + this.constructTableLine(columnsAdressTwo);
            String[] columnsZipCode = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.zipcode", (Object[])new Object[0]) + boldItalicEnd, "<i>" + (StringUtils.isNotEmpty((CharSequence)identity.getZipCode()) ? identity.getZipCode() : " - ") + "</i>"};
            headerTitle = headerTitle + this.constructTableLine(columnsZipCode);
            String[] columnsCity = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.city", (Object[])new Object[0]) + boldItalicEnd, "<i>" + (StringUtils.isNotEmpty((CharSequence)identity.getCity()) ? identity.getCity() : " - ") + "</i>"};
            headerTitle = headerTitle + this.constructTableLine(columnsCity);
            String[] columnsBusinessNumber = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.businessnumber", (Object[])new Object[0]) + boldItalicEnd, "<i>" + (StringUtils.isNotEmpty((CharSequence)identity.getBusinessNumber()) ? identity.getBusinessNumber() : " - ") + "</i>"};
            headerTitle = headerTitle + this.constructTableLine(columnsBusinessNumber);
            String[] columnsClassifCode = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.classificationcode", (Object[])new Object[0]) + boldItalicEnd, "<i>" + (StringUtils.isNotEmpty((CharSequence)identity.getClassificationCode()) ? identity.getClassificationCode() : " - ") + "</i>"};
            headerTitle = headerTitle + this.constructTableLine(columnsClassifCode);
            String[] columnsVatNumber = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.vatnumber", (Object[])new Object[0]) + boldItalicEnd, "<i>" + (StringUtils.isNotEmpty((CharSequence)identity.getVatNumber()) ? identity.getVatNumber() : " - ") + "</i>"};
            headerTitle = headerTitle + this.constructTableLine(columnsVatNumber);
        }
        String[] columnsPeriodOne = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.period1", (Object[])new Object[0]) + boldItalicEnd, "<i>" + I18n.t((String)"lima-business.document.period1format", (Object[])new Object[]{beginDate}) + "</i>"};
        headerTitle = headerTitle + this.constructTableLine(columnsPeriodOne);
        headerTitle = headerTitle + "<tr>\n";
        String[] columnsPeriodTwo = new String[]{boldItalicBegin + I18n.t((String)"lima-business.document.period2", (Object[])new Object[0]) + boldItalicEnd, "<i>" + I18n.t((String)"lima-business.document.period2format", (Object[])new Object[]{endDate}) + "</i>"};
        headerTitle = headerTitle + this.constructTableLine(columnsPeriodTwo);
        headerTitle = headerTitle + "</table></td></table>";
        return headerTitle;
    }

    public DocumentReport createBalanceDocuments(Date beginDate, Date endDate, String fromToAccount) {
        DocumentReport report = this.balanceReportService.getBalanceDocumentReport(beginDate, endDate, fromToAccount, BigDecimalToString.getDecimalFormat());
        this.reportBuilder.generatePDFReport(org.chorem.lima.business.utils.DocumentsEnum.BALANCE, this.BALANCE_FILE_PATH, Lists.newArrayList((Object[])new DocumentReport[]{report}));
        return report;
    }

    public DocumentReport createGeneralEntryBooksDocuments(Date beginDate, Date endDate) {
        DocumentReport report = this.generalEntryBookReportService.getGeneralEntryBookDocumentReport(beginDate, endDate, BigDecimalToString.getDecimalFormat());
        this.reportBuilder.generatePDFReport(org.chorem.lima.business.utils.DocumentsEnum.GENERAL_ENTRYBOOK, this.GENERAL_ENTRY_BOOK_REPORT_PDF_FILE_PATH, Lists.newArrayList((Object[])new DocumentReport[]{report}));
        return report;
    }

    public DocumentReport createEntryBooksDocuments(Date beginDate, Date endDate, List<String> entryBookCodes) {
        DocumentReport report = this.entryBookReportService.getEntryBookDocumentReport(beginDate, endDate, entryBookCodes, BigDecimalToString.getDecimalFormat());
        this.reportBuilder.generatePDFReport(org.chorem.lima.business.utils.DocumentsEnum.ENTRYBOOKS, this.ENTRY_BOOKS_REPORT_PDF_FILE_PATH, Lists.newArrayList((Object[])new DocumentReport[]{report}));
        return report;
    }

    public DocumentReport createLedgerDocuments(Date beginDate, Date endDate) {
        DocumentReport report = this.ledgerReportService.getLedgerDocumentReport(beginDate, endDate, BigDecimalToString.getDecimalFormat());
        this.reportBuilder.generatePDFReport(org.chorem.lima.business.utils.DocumentsEnum.LEDGER, this.LEDGER_REPORT_PDF_FILE_PATH, Lists.newArrayList((Object[])new DocumentReport[]{report}));
        return report;
    }
}

