/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.service.neogia.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.AccountDTO;
import org.ofbiz.webservice.wrappers.xsd.GenericValueNGlAccount;

public class NGLAccountToAccountDTO {
    private static final Log log = LogFactory.getLog(NGLAccountToAccountDTO.class);
    private static Map<String, AccountDTO> map;

    public NGLAccountToAccountDTO() {
        map = new HashMap<String, AccountDTO>();
    }

    public AccountDTO loadArray(GenericValueNGlAccount[] array) {
        AccountDTO planComptable = new AccountDTO("0", "0", "Plan comptable", null, new LinkedList(), null);
        map.put("0", planComptable);
        for (GenericValueNGlAccount node : array) {
            String number = node.getAccount();
            String description = node.getDescription();
            String parentNumber = NGLAccountToAccountDTO.extractParentNumber(node.getTreePath());
            AccountDTO acc = new AccountDTO("0", number, description, null, new LinkedList(), null);
            map.put(number, acc);
            if (!map.containsKey(parentNumber)) continue;
            AccountDTO parent = map.get(parentNumber);
            parent.addChild(acc);
        }
        return map.get("0");
    }

    public static String extractParentNumber(String treePath) {
        Pattern p = Pattern.compile("[0-9]+");
        Matcher m = p.matcher(treePath);
        if (m.find()) {
            return m.group();
        }
        return "0";
    }
}

