/**
 * *##% Lima Neogia service
 * Copyright (C) 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.lima.service.neogia;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.StatusDTO;
import org.chorem.lima.service.StatusService;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.ofbiz.webservice.proxies.GetAllStatusResponseDocument;
import org.ofbiz.webservice.wrappers.xsd.GenericValueStatusItem;

import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;

/**
 * @author ore
 */
public class NeogiaStatusService implements StatusService {

    /**
     * log
     */
    protected static final Log log = LogFactory.getLog(NeogiaStatusService.class);
    protected static final String VALIDATE = "ATS_FINALIZED";
    protected static final String BALANCED = "ATS_BALANCED";
    protected static final String WIP = "ATS_WIP";

    @Override
    public List<StatusDTO> getAllStatus() {
        List<StatusDTO> list = new LinkedList<StatusDTO>();
        try {
            GetAllStatusStub stub = new GetAllStatusStub();
            GetAllStatusResponseDocument response = stub.getAllStatus();
            GenericValueStatusItem[] array = response.getGetAllStatusResponse().getReturnArray();

            for (GenericValueStatusItem value : array) {
                StatusDTO status = NeogiaUtil.mapToStatusDTO(value);
                list.add(status);
            }
            return list;
        } catch (RemoteException ex) {
            log.error(ex);
            return null;
        }

    }

}
