/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.entity.Users;
import org.chorem.callao.entity.UsersDAO;
import org.chorem.callao.service.utils.ContextCallao;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class UserServiceImpl {
    private static final Log log = LogFactory.getLog(UserServiceImpl.class);
    private TopiaContext rootContext = ContextCallao.getInstance().getContext();

    public String addUser(String name) {
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            UsersDAO userdao = CallaoDAOHelper.getUsersDAO((TopiaContext)topiaContext);
            Users newuser = (Users)userdao.create(new Object[0]);
            newuser.setMatcher(name);
            topiaContext.commitTransaction();
            topiaContext.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Add user : " + name));
            }
            return "success";
        }
        catch (TopiaException e) {
            log.error((Object)e);
            return "error";
        }
    }

    public String findUser(String name) {
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            UsersDAO userdao = CallaoDAOHelper.getUsersDAO((TopiaContext)topiaContext);
            Users newuser = userdao.findByMatcher(name);
            topiaContext.closeContext();
            if (newuser == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Not find : " + name));
                }
                return "error";
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Find user : " + name));
            }
            return "success";
        }
        catch (TopiaException e) {
            log.error((Object)e);
            return "error";
        }
    }
}

