/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.chenillekit.tapestry.core.utils.ProtoTubeIdHolder;

@SupportsInformalParameters
@Import(library={"prototube/prototube.js", "prototube/swfobject.js", "${tapestry.scriptaculous}/effects.js"}, stylesheet={"prototube/prototube.css"})
public class ProtoTube
implements ClientElement {
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(required=true, defaultPrefix="prop")
    private List<ProtoTubeIdHolder> youtubeIds;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private ComponentResources resources;
    private String assignedClientId;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
    }

    void beginRender(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", this.getClientId()});
        this.resources.renderInformalParameters(writer);
        for (ProtoTubeIdHolder youtubeId : this.youtubeIds) {
            writer.element("a", new Object[]{"href", youtubeId.getId(), "title", youtubeId.getTitle()});
            writer.end();
        }
        writer.end();
    }

    void afterRender(MarkupWriter writer) {
        JSONObject config = new JSONObject();
        config.put("hd", (Object)1);
        config.put("showinfo", (Object)1);
        this.configure(config);
        this.javascriptSupport.addScript("$$('div#%s a').each( function(el) {new ProtoTube(el, %s);});", new Object[]{this.getClientId(), config});
    }

    protected void configure(JSONObject config) {
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

