/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Mixin;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.corelib.mixins.RenderInformals;

public class DateFormat {
    public static int BODY_POS_NONE = 0;
    public static int BODY_POS_LEFT = 1;
    public static int BODY_POS_RIGHT = 2;
    @Parameter(required=true, defaultPrefix="prop")
    private Date value;
    @Parameter(required=false, defaultPrefix="literal", value="yyyy-MM-dd")
    private String pattern;
    @Parameter(required=false, defaultPrefix="literal", value="0")
    private int bodyPosition;
    @Mixin
    private RenderInformals renderInformals;
    private SimpleDateFormat sdf;

    @SetupRender
    void setupRender() {
        this.sdf = new SimpleDateFormat();
    }

    boolean beginRender(MarkupWriter writer) {
        if (this.value == null) {
            return false;
        }
        this.sdf.applyPattern(this.pattern);
        if (this.bodyPosition == BODY_POS_NONE || this.bodyPosition == BODY_POS_RIGHT) {
            writer.write(this.sdf.format(this.value));
        }
        return this.bodyPosition != BODY_POS_NONE;
    }

    void afterRender(MarkupWriter writer) {
        if (this.value == null) {
            return;
        }
        if (this.bodyPosition == BODY_POS_LEFT) {
            writer.write(this.sdf.format(this.value));
        }
    }
}

