/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
@Import(library={"../Chenillekit.js", "CkOnEvents.js"})
public class Button
implements ClientElement {
    static final String CLICKED_EVENT = "clicked";
    static final String TYPE_BUTTON = "button";
    static final String TYPE_SUBMIT = "submit";
    static final String TYPE_RESET = "reset";
    @Parameter(defaultPrefix="literal", value="button")
    private String type;
    @Parameter(defaultPrefix="literal", value="clicked")
    private String event;
    @Parameter(defaultPrefix="literal", required=false)
    private String pageName;
    @Parameter(value="false")
    private boolean disabled;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(value="literal:false")
    private boolean confirm;
    @Parameter
    private List<?> context;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private ComponentResources resources;
    @Inject
    private PageRenderLinkSource pageRenderResources;
    @Inject
    private Messages messages;
    private String assignedClientId;
    private Object[] contextArray;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
        this.contextArray = this.context == null ? new Object[]{} : this.context.toArray();
    }

    void beginRender(MarkupWriter writer) {
        writer.element(TYPE_BUTTON, new Object[]{"type", this.type, "id", this.getClientId()});
        this.resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        if (!this.disabled && this.type.equalsIgnoreCase(TYPE_BUTTON)) {
            Link link = this.pageName != null ? this.pageRenderResources.createPageRenderLinkWithContext(this.pageName, this.contextArray) : this.resources.createEventLink(this.event, this.contextArray);
            String message = "";
            if (this.confirm) {
                message = this.messages.format("ck-button-confirm-message", new Object[]{this.clientId});
            }
            this.javascriptSupport.addScript("new Ck.ButtonEvent('%s', '%s', '%s');", new Object[]{this.getClientId(), link.toAbsoluteURI(), message});
        }
        writer.end();
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

