/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.factories;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.internal.services.ResourceCache;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.AssetFactory;
import org.chenillekit.core.resources.URIResource;
import org.chenillekit.tapestry.core.services.URIAssetAliasManager;

public class URIAssetFactory
implements AssetFactory {
    private final ResourceCache cache;
    private final URIAssetAliasManager aliasManager;
    private final Map<Resource, String> resourceToClientURL = CollectionFactory.newConcurrentMap();

    public URIAssetFactory(ResourceCache cache, URIAssetAliasManager aliasManager) {
        this.cache = cache;
        this.aliasManager = aliasManager;
    }

    public Resource getRootResource() {
        return new URIResource("/");
    }

    private String clientURL(Resource resource) {
        String clientURL = this.resourceToClientURL.get(resource);
        if (clientURL == null) {
            clientURL = this.buildClientURL(resource);
            this.resourceToClientURL.put(resource, clientURL);
        }
        return this.aliasManager.toClientURL(clientURL);
    }

    private String buildClientURL(Resource resource) {
        boolean requiresDigest = this.cache.requiresDigest(resource);
        String path = null;
        try {
            path = URLEncoder.encode(resource.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (requiresDigest) {
            int lastdotx = path.lastIndexOf(46);
            path = path.substring(0, lastdotx + 1) + this.cache.getDigest(resource) + path.substring(lastdotx);
        }
        return path;
    }

    public Asset createAsset(final Resource resource) {
        return new Asset(){

            public Resource getResource() {
                return resource;
            }

            public String toClientURL() {
                return URIAssetFactory.this.clientURL(resource);
            }

            public String toString() {
                return this.toClientURL();
            }
        };
    }
}

