/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.services.BindingFactory;
import org.apache.tapestry5.services.BindingSource;
import org.chenillekit.tapestry.core.bindings.MessageFormatBinding;

public class MessageFormatBindingFactory
implements BindingFactory {
    private final BindingSource _bindingSource;

    public MessageFormatBindingFactory(BindingSource bindingSource) {
        this._bindingSource = bindingSource;
    }

    public Binding newBinding(String description, ComponentResources container, ComponentResources component, String expression, Location location) {
        String messageKey = expression.substring(0, expression.indexOf(61));
        List<String> parts = Arrays.asList(expression.substring(expression.indexOf(61) + 1).split(","));
        ArrayList<Binding> bindings = new ArrayList<Binding>(parts.size());
        for (String part : parts) {
            String prefix = "prop";
            if ('\'' == (part = part.trim()).charAt(0) && '\'' == part.charAt(part.length() - 1)) {
                part = part.substring(1, part.length() - 1);
                prefix = "literal";
            }
            bindings.add(this._bindingSource.newBinding(description, container, component, prefix, part, location));
        }
        boolean invariant = true;
        for (Binding binding : bindings) {
            if (binding.isInvariant()) continue;
            invariant = false;
            break;
        }
        return new MessageFormatBinding(location, messageKey, component.getMessages(), bindings, invariant);
    }
}

