/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.Block;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.PrimaryKeyEncoder;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.corelib.components.Delegate;
import org.apache.tapestry5.corelib.components.Loop;
import org.apache.tapestry5.util.StringToEnumCoercion;
import org.chenillekit.tapestry.core.components.Pager;
import org.chenillekit.tapestry.core.internal.PagedSource;
import org.chenillekit.tapestry.core.internal.PagerPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedLoop
implements ClientElement {
    @Environmental
    private RenderSupport _pageRenderSupport;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String _clientId;
    @Parameter(value="prop:componentResources.elementName", defaultPrefix="literal")
    private String element;
    @Parameter(required=true)
    private Iterable<?> _source;
    private PagedSource<?> _pagedSource;
    @Parameter(value="bottom", defaultPrefix="literal")
    private String _pagerPosition;
    private PagerPosition _internalPagerPosition;
    @Parameter(value="25")
    private int _rowsPerPage;
    @Persist
    private int _currentPage;
    @Parameter
    private Object _value;
    @Parameter
    private boolean _volatile;
    @Parameter
    private int _index;
    @Parameter
    private PrimaryKeyEncoder<?, ?> _encoder;
    @Component(parameters={"source=pagedSource", "element=prop:element", "value=inherit:value", "volatile=inherit:volatile", "encoder=inherit:encoder", "index=inherit:index"})
    private Loop _loop;
    @Component(parameters={"source=pagedSource", "rowsPerPage=rowsPerPage", "currentPage=currentPage"})
    private Pager _internalPager;
    @Component(parameters={"to=pagerTop"})
    private Delegate _pagerTop;
    @Component(parameters={"to=pagerBottom"})
    private Delegate _pagerBottom;
    @Parameter(value="block:empty")
    private Block _empty;
    private String _assignedClientId;

    public String getElement() {
        return this.element;
    }

    public Object getPagerTop() {
        return this._internalPagerPosition.isMatchTop() ? this._internalPager : null;
    }

    public Object getPagerBottom() {
        return this._internalPagerPosition.isMatchBottom() ? this._internalPager : null;
    }

    public PagedSource<?> getPagedSource() {
        return this._pagedSource;
    }

    public int getRowsPerPage() {
        return this._rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this._rowsPerPage = rowsPerPage;
    }

    public int getCurrentPage() {
        return this._currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this._currentPage = currentPage;
    }

    Object setupRender() {
        if (this._currentPage == 0) {
            this._currentPage = 1;
        }
        this._assignedClientId = this._pageRenderSupport.allocateClientId(this._clientId);
        this._internalPagerPosition = (PagerPosition)new StringToEnumCoercion(PagerPosition.class).coerce(this._pagerPosition);
        this._pagedSource = new PagedSource(this._source);
        int availableRows = this._pagedSource.getTotalRowCount();
        if (availableRows == 0) {
            return this._empty;
        }
        int startIndex = (this._currentPage - 1) * this._rowsPerPage;
        int endIndex = Math.min(startIndex + this._rowsPerPage - 1, availableRows - 1);
        this._pagedSource.prepare(startIndex, endIndex);
        return null;
    }

    @BeginRender
    Object begin() {
        return this._pagedSource.getTotalRowCount() != 0;
    }

    void onAction(int newPage) {
        this._currentPage = newPage;
    }

    public String getClientId() {
        return this._assignedClientId;
    }
}

