/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.SelectModelVisitor;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.util.EnumSelectModel;
import org.chenillekit.tapestry.core.encoders.MultipleValueEncoder;
import org.chenillekit.tapestry.core.renderes.MultipleSelectModelRenderer;

public class MultipleSelect
extends AbstractField {
    @Parameter
    private MultipleValueEncoder encoder;
    @Parameter(required=true)
    private SelectModel model;
    @Parameter(defaultPrefix="prop", value="true")
    private boolean multiple;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Parameter(required=true, principal=true)
    private List value;
    @Inject
    private Locale locale;
    @Inject
    private Request request;
    @Inject
    private ComponentResources resources;
    @Environmental
    private ValidationTracker tracker;
    @Inject
    private ComponentDefaultProvider defaultProvider;

    protected void processSubmission(String elementName) {
        String[] primaryKeys = this.request.getParameters(elementName);
        List selectedValues = primaryKeys != null ? this.encoder.toValue(primaryKeys) : CollectionFactory.newList();
        try {
            for (Object selectedValue : selectedValues) {
                this.validate.validate(selectedValue);
            }
            if (this.validate.isRequired() && selectedValues.size() == 0) {
                throw new ValidationException("at least one selection is required");
            }
            this.value = selectedValues;
        }
        catch (ValidationException ex) {
            this.tracker.recordError((Field)this, ex.getMessage());
        }
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    void beginRender(MarkupWriter writer) {
        Element element = writer.element("select", new Object[]{"name", this.getControlName(), "id", this.getClientId()});
        if (this.multiple) {
            element.attribute("multiple", "multiple");
        }
        this.resources.renderInformalParameters(writer);
    }

    ValueEncoder defaultEncoder() {
        return this.defaultProvider.defaultValueEncoder("value", this.resources);
    }

    SelectModel defaultModel() {
        Class valueType = this.resources.getBoundType("value");
        if (valueType == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(valueType)) {
            return new EnumSelectModel(valueType, this.resources.getContainerMessages());
        }
        return null;
    }

    Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("value", this.resources);
    }

    Binding defaultValue() {
        return this.createDefaultParameterBinding("value");
    }

    @BeforeRenderTemplate
    void options(MarkupWriter writer) {
        Renderer renderer = new Renderer(writer);
        if (this.model == null) {
            throw new TapestryException("select model cannot be null", (Object)this, null);
        }
        this.model.visit((SelectModelVisitor)renderer);
    }

    public void setModel(SelectModel model) {
        this.model = model;
    }

    public void setValue(List value) {
        this.value = value;
    }

    public void setValueEncoder(MultipleValueEncoder encoder) {
        this.encoder = encoder;
    }

    private class Renderer
    extends MultipleSelectModelRenderer {
        public Renderer(MarkupWriter writer) {
            super(writer, MultipleSelect.this.encoder);
        }

        protected boolean isOptionSelected(OptionModel optionModel) {
            boolean hit;
            block1: {
                Object singleValue;
                hit = false;
                Object testValue = optionModel.getValue();
                if (MultipleSelect.this.value == null) break block1;
                Iterator i$ = MultipleSelect.this.value.iterator();
                while (i$.hasNext() && !(hit = testValue == (singleValue = i$.next()) || testValue != null && testValue.equals(singleValue))) {
                }
            }
            return hit;
        }
    }
}

