/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.FieldValidatorDefaultSource;
import org.apache.tapestry5.services.Request;

@IncludeStylesheet(value={"datetimefield/datepicker.css"})
@IncludeJavaScriptLibrary(value={"datetimefield/datepicker.js", "../prototype-base-extensions.js", "../prototype-date-extensions.js"})
public class DateTimeField
extends AbstractField {
    @Parameter(required=true, principal=true)
    private Date value;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Parameter(defaultPrefix="asset", value="datetimefield/calendar.png")
    private Asset icon;
    @Parameter(defaultPrefix="literal", value="MM/dd/yyyy")
    private String datePattern;
    @Parameter(defaultPrefix="prop", value="true")
    private boolean datePicker;
    @Parameter(defaultPrefix="prop", value="false")
    private boolean timePicker;
    @Parameter(defaultPrefix="prop", value="false")
    private boolean timePickerAdjacent;
    @Parameter(defaultPrefix="prop", value="false")
    private boolean use24hrs;
    @Parameter(defaultPrefix="literal", required=false)
    private String afterUpdateElement;
    @Parameter(defaultPrefix="prop", value="true")
    private boolean lenient;
    @Environmental
    private RenderSupport support;
    @Environmental
    private ValidationTracker tracker;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Inject
    private Request request;
    @Inject
    private Locale locale;
    @Inject
    private FieldValidatorDefaultSource fieldValidatorDefaultSource;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    @Path(value="datetimefield/clock.png")
    private Asset clockAsset;
    private DateFormat outputFormat;
    private DateFormat inputFormat;

    final Binding defaultValue() {
        return this.createDefaultParameterBinding("value");
    }

    final Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("value", this.resources);
    }

    void setupRender() {
        this.outputFormat = new SimpleDateFormat(this.datePattern, this.locale);
    }

    void beginRender(MarkupWriter writer) {
        String value = this.tracker.getInput((Field)this);
        if (value == null) {
            value = this.formatCurrentValue();
        }
        String clientId = this.getClientId();
        writer.element("input", new Object[]{"type", "text", "class", "datepicker", "name", this.getControlName(), "id", clientId, "value", value});
        this.writeDisabled(writer);
        this.validate.render(writer);
        this.resources.renderInformalParameters(writer);
        this.decorateInsideField();
        writer.end();
        JSONObject setup = new JSONObject();
        if (!this.datePicker && !this.timePicker) {
            throw new RuntimeException("both date- and timePicker set to false, that is senseless!");
        }
        Asset componentIcon = !this.datePicker && this.timePicker ? this.clockAsset : this.icon;
        setup.put("icon", (Object)componentIcon.toClientURL());
        setup.put("datePicker", (Object)this.datePicker);
        setup.put("timePicker", (Object)this.timePicker);
        setup.put("timePickerAdjacent", (Object)this.timePickerAdjacent);
        setup.put("use24hrs", (Object)this.use24hrs);
        setup.put("locale", (Object)this.locale.toString());
        if (this.afterUpdateElement != null) {
            setup.put("afterUpdateElement", (Object)this.afterUpdateElement);
        }
        if (this.datePicker && this.timePicker) {
            setup.put("dateTimeFormat", (Object)this.datePattern);
        } else if (this.datePicker) {
            setup.put("dateFormat", (Object)this.datePattern);
        } else {
            setup.put("timeFormat", (Object)this.datePattern);
        }
        this.support.addScript("new Control.DatePicker('%s', %s);", new Object[]{this.getClientId(), setup});
    }

    private void writeDisabled(MarkupWriter writer) {
        if (this.isDisabled()) {
            writer.attributes(new Object[]{"disabled", "disabled"});
        }
    }

    private String formatCurrentValue() {
        if (this.value == null) {
            return "";
        }
        return this.outputFormat.format(this.value);
    }

    protected void processSubmission(String elementName) {
        String value = this.request.getParameter(elementName);
        this.tracker.recordInput((Field)this, value);
        Date parsedValue = null;
        try {
            if (InternalUtils.isNonBlank((String)value)) {
                this.inputFormat = new SimpleDateFormat(this.datePattern, this.locale);
                this.inputFormat.setLenient(this.lenient);
                parsedValue = this.inputFormat.parse(value);
            }
        }
        catch (ParseException ex) {
            this.tracker.recordError((Field)this, this.messages.format("date.not.parseable", new Object[]{value}));
            return;
        }
        try {
            this.fieldValidationSupport.validate(parsedValue, this.resources, this.validate);
            this.value = parsedValue;
        }
        catch (ValidationException ex) {
            this.tracker.recordError((Field)this, ex.getMessage());
        }
    }

    void injectResources(ComponentResources resources) {
        this.resources = resources;
    }

    void injectMessages(Messages messages) {
        this.messages = messages;
    }

    public boolean isRequired() {
        return this.validate.isRequired();
    }
}

