/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;

@SupportsInformalParameters
@IncludeJavaScriptLibrary(value={"../Chenillekit.js", "CkOnEvents.js"})
public class Button
implements ClientElement {
    static final String CLICKED_EVENT = "clicked";
    static final String BUTTON_TYPE = "button";
    static final String SUBMIT_TYPE = "submit";
    static final String CANCEL_TYPE = "cancel";
    static final String PAGE_TYPE = "page";
    @Parameter(defaultPrefix="literal", value="button")
    private String type;
    @Parameter(defaultPrefix="literal", value="clicked")
    private String event;
    @Parameter(defaultPrefix="literal", required=false)
    private String pageName;
    @Parameter(value="false")
    private boolean disabled;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter
    private List<?> context;
    @Environmental
    private RenderSupport renderSupport;
    @Inject
    private ComponentResources resources;
    private String assignedClientId;
    private Object[] contextArray;

    void setupRender() {
        this.assignedClientId = this.renderSupport.allocateClientId(this.clientId);
        this.contextArray = this.context == null ? new Object[]{} : this.context.toArray();
    }

    void beginRender(MarkupWriter writer) {
        writer.element(BUTTON_TYPE, new Object[]{"type", this.type, "id", this.getClientId()});
        this.resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        if (!this.disabled && (this.type.equalsIgnoreCase(BUTTON_TYPE) || this.type.equalsIgnoreCase(PAGE_TYPE))) {
            Link link;
            if (!this.type.equalsIgnoreCase(PAGE_TYPE)) {
                link = this.resources.createEventLink(this.event, this.contextArray);
            } else {
                if (this.pageName == null) {
                    throw new RuntimeException("parameter 'pageName' can not be null for button typed page link");
                }
                link = this.resources.createPageLink(this.pageName, this.resources.isBound("context"), this.contextArray);
            }
            this.renderSupport.addScript("new Ck.ButtonEvent('%s', '%s');", new Object[]{this.getClientId(), link.toAbsoluteURI()});
        }
        writer.end();
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

