/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Environment;

@SupportsInformalParameters
@IncludeJavaScriptLibrary(value={"../Chenillekit.js", "Accordion.js"})
@IncludeStylesheet(value={"Accordion.css"})
public class Accordion
implements ClientElement {
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String _clientId;
    @Parameter(required=true)
    private List<?> _subjects;
    @Parameter(required=true)
    private List<?> _details;
    @Parameter(value="false", required=false)
    private boolean _renderDetailsRaw;
    @Parameter(value="0.2", required=false)
    private String duration;
    @Inject
    private ComponentResources _resources;
    @Environmental
    private RenderSupport _pageRenderSupport;
    @Inject
    private Environment _environment;
    private String _assignedClientId;

    void setupRender() {
        this._assignedClientId = this._pageRenderSupport.allocateClientId(this._clientId);
    }

    void beginRender(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", this.getClientId()});
        this._resources.renderInformalParameters(writer);
        Object[] subjectsArray = this._subjects.toArray();
        Object[] detailsArray = this._details.toArray();
        for (int i = 0; i < subjectsArray.length; ++i) {
            String subject = subjectsArray[i].toString();
            String detail = "";
            if (detailsArray.length >= i + 1) {
                detail = detailsArray[i].toString();
            }
            writer.element("div", new Object[]{"id", this.getClientId() + "_toggle_" + i, "class", "ck_accordionToggle"});
            writer.write(subject);
            writer.end();
            writer.element("div", new Object[]{"id", this.getClientId() + "_content_" + i, "class", "ck_accordionContent", "style", "display: none;"});
            writer.element("div", new Object[0]);
            if (this._renderDetailsRaw) {
                writer.writeRaw(detail);
            } else {
                writer.write(detail);
            }
            writer.end();
            writer.end();
        }
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        this._pageRenderSupport.addScript("new Ck.Accordion('%s', {duration: %s});", new Object[]{this.getClientId(), this.duration});
    }

    public String getClientId() {
        return this._assignedClientId;
    }
}

