/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.processor.Processor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityContextTokenProcessor
implements Processor {
    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        SecurityContextToken sct = new SecurityContextToken(elem);
        byte[] secret = this.getSecret(data.getCallbackHandler(), sct);
        WSSecurityEngineResult result = new WSSecurityEngineResult(1024, sct);
        wsDocInfo.addTokenElement(elem);
        result.put("id", sct.getID());
        result.put("secret", secret);
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }

    private byte[] getSecret(CallbackHandler cb, SecurityContextToken sct) throws WSSecurityException {
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        WSPasswordCallback callback = new WSPasswordCallback(sct.getIdentifier(), 6);
        try {
            Callback[] callbacks = new Callback[]{callback};
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{sct.getIdentifier()}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{sct.getIdentifier()}, e);
        }
        return callback.getKey();
    }
}

