/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.ds.OMDataSourceExtBase;
import org.apache.axiom.om.util.StAXUtils;

public class ByteArrayDataSource
extends OMDataSourceExtBase {
    ByteArray byteArray = new ByteArray();

    public ByteArrayDataSource(byte[] bytes, String encoding) {
        this.byteArray.bytes = bytes;
        this.byteArray.encoding = encoding;
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        return StAXUtils.createXMLStreamReader(new ByteArrayInputStream(this.byteArray.bytes), this.byteArray.encoding);
    }

    public Object getObject() {
        return this.byteArray;
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        if (!this.byteArray.encoding.equalsIgnoreCase(encoding)) {
            String text = new String(this.byteArray.bytes, this.byteArray.encoding);
            this.byteArray.bytes = text.getBytes(encoding);
            this.byteArray.encoding = encoding;
        }
        return this.byteArray.bytes;
    }

    public void close() {
        this.byteArray = null;
    }

    public OMDataSourceExt copy() {
        return new ByteArrayDataSource(this.byteArray.bytes, this.byteArray.encoding);
    }

    public class ByteArray {
        public byte[] bytes;
        public String encoding;
    }
}

