/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry.metadata;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Encoded;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.InjectableFactory;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.ConstructorMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetadataCollector {
    private final ClassMetadata metadata;

    public AbstractMetadataCollector(Class<?> clazz) {
        this.metadata = new ClassMetadata(clazz);
    }

    protected final void parseFields() {
        List<Injectable> injectableFields = this.metadata.getInjectableFields();
        for (Class<?> resourceClass = this.metadata.getResourceClass(); resourceClass != Object.class; resourceClass = resourceClass.getSuperclass()) {
            for (Field field : resourceClass.getDeclaredFields()) {
                Type fieldType = field.getGenericType();
                Injectable injectable = this.parseAccessibleObject(field, fieldType);
                if (injectable == null) continue;
                injectableFields.add(injectable);
            }
        }
        PropertyDescriptor[] propertyDescriptors = this.metadata.getBeanInfo().getPropertyDescriptors();
        if (propertyDescriptors != null) {
            for (PropertyDescriptor pd : propertyDescriptors) {
                Class<?> genericReturnType;
                Injectable injectable;
                Method writeMethod = pd.getWriteMethod();
                if (writeMethod == null || (injectable = this.parseAccessibleObject(writeMethod, genericReturnType = writeMethod.getParameterTypes()[0])) == null) continue;
                injectableFields.add(injectable);
            }
        }
    }

    protected abstract Injectable parseAccessibleObject(AccessibleObject var1, Type var2);

    protected abstract boolean isConstructorParameterValid(Injectable var1);

    protected final void parseConstructors() {
        ConstructorMetadata constructorMetadata = new ConstructorMetadata();
        ArrayList<Injectable> formalParameters = new ArrayList<Injectable>();
        Class<?> resourceClass = this.metadata.getResourceClass();
        block0: for (Constructor<?> constructor : resourceClass.getDeclaredConstructors()) {
            int modifiers = constructor.getModifiers();
            if (!Modifier.isPublic(modifiers)) continue;
            constructorMetadata.setEncoded(constructor.getAnnotation(Encoded.class) != null);
            formalParameters.clear();
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Type[] paramTypes = constructor.getGenericParameterTypes();
            int limit = paramTypes.length;
            for (int pos = 0; pos < limit; ++pos) {
                Injectable fp = InjectableFactory.getInstance().create(paramTypes[pos], parameterAnnotations[pos], constructor, this.getMetadata().isEncoded() || constructorMetadata.isEncoded(), null);
                if (!this.isConstructorParameterValid(fp)) continue block0;
                formalParameters.add(fp);
            }
            if (constructorMetadata.getConstructor() == null || constructorMetadata.getFormalParameters().size() < paramTypes.length) {
                constructorMetadata.setConstructor(constructor);
                constructorMetadata.getFormalParameters().clear();
                constructorMetadata.getFormalParameters().addAll(formalParameters);
                continue;
            }
            if (constructorMetadata.getFormalParameters().size() != paramTypes.length) continue;
        }
        this.metadata.setConstructor(constructorMetadata);
    }

    protected void parseEncoded(Class<?> cls) {
        Encoded encoded = cls.getAnnotation(Encoded.class);
        if (encoded != null) {
            this.metadata.setEncoded(true);
        }
    }

    public ClassMetadata getMetadata() {
        return this.metadata;
    }
}

