/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.authenticator;

import java.security.Principal;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.authenticator.ClusterSingleSignOnListener;
import org.apache.catalina.ha.authenticator.SingleSignOnMessage;

public class ClusterSingleSignOn
extends SingleSignOn {
    protected static String info = "org.apache.catalina.cluster.authenticator.ClusterSingleSignOn";
    protected int messageNumber = 0;
    private ClusterSingleSignOnListener clusterSSOListener = null;
    private CatalinaCluster cluster = null;

    public String getInfo() {
        return info;
    }

    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    public void start() throws LifecycleException {
        super.start();
        this.clusterSSOListener = new ClusterSingleSignOnListener();
        this.clusterSSOListener.setClusterSSO(this);
        try {
            Container host;
            CatalinaCluster cluster = this.getCluster();
            if (cluster == null && (host = this.getContainer()) != null && host instanceof Host) {
                cluster = host.getCluster();
                if (cluster != null && cluster instanceof CatalinaCluster) {
                    this.setCluster(cluster);
                    this.getCluster().addClusterListener(this.clusterSSOListener);
                } else {
                    Container engine = host.getParent();
                    if (engine != null && engine instanceof Engine) {
                        cluster = engine.getCluster();
                        if (cluster != null && cluster instanceof CatalinaCluster) {
                            this.setCluster(cluster);
                            this.getCluster().addClusterListener(this.clusterSSOListener);
                        }
                    } else {
                        cluster = null;
                    }
                }
            }
            if (cluster == null) {
                throw new LifecycleException("There is no Cluster for ClusterSingleSignOn");
            }
        }
        catch (Throwable t) {
            throw new LifecycleException("ClusterSingleSignOn exception during clusterLoad " + t);
        }
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.getCluster() != null && this.getCluster() instanceof CatalinaCluster) {
            this.getCluster().removeClusterListener(this.clusterSSOListener);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ClusterSingleSignOn[");
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    protected void associate(String ssoId, Session session) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, session.getId());
            Manager mgr = session.getManager();
            if (mgr != null && mgr instanceof ClusterManager) {
                msg.setContextName(((ClusterManager)mgr).getName());
            }
            msg.setAction(1);
            this.cluster.sendClusterDomain(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.associateLocal(ssoId, session);
    }

    protected void associateLocal(String ssoId, Session session) {
        super.associate(ssoId, session);
    }

    protected void deregister(String ssoId, Session session) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, session.getId());
            Manager mgr = session.getManager();
            if (mgr != null && mgr instanceof ClusterManager) {
                msg.setContextName(((ClusterManager)mgr).getName());
            }
            msg.setAction(2);
            this.cluster.sendClusterDomain(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.deregisterLocal(ssoId, session);
    }

    protected void deregisterLocal(String ssoId, Session session) {
        super.deregister(ssoId, session);
    }

    protected void deregister(String ssoId) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, null);
            msg.setAction(3);
            this.cluster.sendClusterDomain(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.deregisterLocal(ssoId);
    }

    protected void deregisterLocal(String ssoId) {
        super.deregister(ssoId);
    }

    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, null);
            msg.setAction(4);
            msg.setAuthType(authType);
            msg.setUsername(username);
            msg.setPassword(password);
            this.cluster.sendClusterDomain(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.registerLocal(ssoId, principal, authType, username, password);
    }

    protected void registerLocal(String ssoId, Principal principal, String authType, String username, String password) {
        super.register(ssoId, principal, authType, username, password);
    }

    protected void update(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, null);
            msg.setAction(5);
            msg.setAuthType(authType);
            msg.setUsername(username);
            msg.setPassword(password);
            this.cluster.sendClusterDomain(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.updateLocal(ssoId, principal, authType, username, password);
    }

    protected void updateLocal(String ssoId, Principal principal, String authType, String username, String password) {
        super.update(ssoId, principal, authType, username, password);
    }

    protected void removeSession(String ssoId, Session session) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, session.getId());
            Manager mgr = session.getManager();
            if (mgr != null && mgr instanceof ClusterManager) {
                msg.setContextName(((ClusterManager)mgr).getName());
            }
            msg.setAction(6);
            this.cluster.sendClusterDomain(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.removeSessionLocal(ssoId, session);
    }

    protected void removeSessionLocal(String ssoId, Session session) {
        super.removeSession(ssoId, session);
    }
}

